/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import elemental2.promise.Promise;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.stunner.client.widgets.editor.StunnerEditor;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.documentation.DocumentationPage;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.core.validation.impl.ValidationUtils;
import org.kie.workbench.common.stunner.project.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractProjectDiagramEditor<R extends ClientResourceType>
extends KieEditor<ProjectDiagram> {
    private static Logger LOGGER = Logger.getLogger(AbstractProjectDiagramEditor.class.getName());
    private static final String TITLE_FORMAT_TEMPLATE = "#title.#suffix - #type";
    private final AbstractDiagramEditorMenuSessionItems<?> menuSessionItems;
    private final Event<OnDiagramFocusEvent> onDiagramFocusEvent;
    private final Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent;
    private final ClientTranslationService translationService;
    private final DocumentationView documentationView;
    private final R resourceType;
    private final ProjectMessagesListener projectMessagesListener;
    private final ClientProjectDiagramService projectDiagramServices;
    private final Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller;
    private final StunnerEditor stunnerEditor;
    private String title = null;
    private boolean menuBarInitialized = false;

    public AbstractProjectDiagramEditor(View view, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, DocumentationView documentationView, R resourceType, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ProjectMessagesListener projectMessagesListener, ClientTranslationService translationService, ClientProjectDiagramService projectDiagramServices, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller, StunnerEditor stunnerEditor) {
        super((KieEditorView)view);
        this.menuSessionItems = menuSessionItems;
        this.onDiagramFocusEvent = onDiagramFocusEvent;
        this.onDiagramLostFocusEvent = onDiagramLostFocusEvent;
        this.translationService = translationService;
        this.documentationView = documentationView;
        this.resourceType = resourceType;
        this.projectMessagesListener = projectMessagesListener;
        this.projectDiagramServices = projectDiagramServices;
        this.projectDiagramResourceServiceCaller = projectDiagramResourceServiceCaller;
        this.stunnerEditor = stunnerEditor;
    }

    @PostConstruct
    public void init() {
        this.title = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramEditorDefaultTitle");
        this.projectMessagesListener.enable();
        this.menuSessionItems.setLoadingStarts(this::showLoadingViews).setLoadingCompleted(this::hideLoadingViews).setErrorConsumer(this::logMenuItemError);
        this.getView().setWidget(this.stunnerEditor.getView());
    }

    protected void doStartUp(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.resourceType);
        this.initializeStunnerEditor();
    }

    void initializeStunnerEditor() {
        this.stunnerEditor.setOnResetContentHashProcessor(h -> {
            this.originalHash = h;
        });
        this.stunnerEditor.setParsingExceptionProcessor(e -> {
            ProjectMetadata pm = (ProjectMetadata)e.getMetadata();
            this.updateTitle(pm.getTitle());
            this.resetEditorPagesOnLoadError(pm.getOverview());
            this.menuSessionItems.setEnabled(false);
            this.notification.fire((Object)new NotificationEvent(this.translationService.getValue("DiagramParsingError", new Object[]{Objects.toString(e.getMessage(), "")}), NotificationEvent.NotificationType.ERROR));
        });
        this.stunnerEditor.setExceptionProcessor(e -> this.placeManager.forceClosePlace((PlaceRequest)new PathPlaceRequest((Path)this.versionRecordManager.getCurrentPath(), this.getEditorIdentifier())));
    }

    protected void loadContent() {
        this.destroySession();
        this.projectDiagramServices.getByPath((Path)this.versionRecordManager.getCurrentPath(), (ServiceCallback)new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.open(item);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onError(error);
            }
        });
    }

    public void open(ProjectDiagram diagram) {
        this.open(diagram, new SessionPresenter.SessionPresenterCallback(){

            public void onSuccess() {
            }

            public void onError(ClientRuntimeError error) {
            }
        });
    }

    public void open(final ProjectDiagram diagram, final SessionPresenter.SessionPresenterCallback callback) {
        this.showLoadingViews();
        this.beforeOpen(diagram);
        this.stunnerEditor.open((Diagram)diagram, new SessionPresenter.SessionPresenterCallback(){

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.initialiseKieEditorForSession(diagram);
                callback.onSuccess();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.hideLoadingViews();
                callback.onError(error);
            }
        });
    }

    protected void beforeOpen(ProjectDiagram diagram) {
        this.stunnerEditor.setReadOnly(this.isReadOnly);
    }

    public void initialiseKieEditorForSession(ProjectDiagram diagram) {
        this.resetEditorPages(((ProjectMetadata)diagram.getMetadata()).getOverview());
        this.updateTitle(diagram.getName());
        this.addDocumentationPage(diagram);
        this.hideLoadingViews();
        this.menuSessionItems.bind(this.getSession());
        SaveAndRenameCommandBuilder saveAndRenameCommandBuilder = this.getSaveAndRenameCommandBuilder();
        saveAndRenameCommandBuilder.addContentSupplier(this.getContentSupplier());
    }

    protected void onValidate(Command finished) {
        this.hideLoadingViews();
        finished.execute();
    }

    void ifValidDiagram(final Command command) {
        this.getMenuSessionItems().getCommands().getValidateSessionCommand().execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.onValidate(command);
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                Violation.Type maxSeverity = ValidationUtils.getMaxSeverity(violations);
                if (AbstractProjectDiagramEditor.this.isSaveAllowedAfterValidationFailed(maxSeverity)) {
                    AbstractProjectDiagramEditor.this.onValidate(command);
                } else {
                    AbstractProjectDiagramEditor.this.onValidate(() -> {});
                }
            }
        });
    }

    public boolean isSaveAllowedAfterValidationFailed(Violation.Type maxSeverity) {
        return !maxSeverity.equals((Object)Violation.Type.ERROR);
    }

    protected void save(String commitMessage) {
        if (!this.stunnerEditor.isXmlEditorEnabled()) {
            this.ifValidDiagram(() -> this.saveOrUpdate(commitMessage));
        } else {
            this.saveAsXML(commitMessage);
        }
    }

    protected void onSave() {
        if (this.hasUnsavedChanges()) {
            super.onSave();
        } else if (!this.versionRecordManager.isCurrentLatest()) {
            super.onSave();
        } else {
            this.showMessage(CommonConstants.INSTANCE.NoChangesSinceLastSave());
        }
    }

    private void saveOrUpdate(String commitMessage) {
        final ObservablePath diagramPath = this.versionRecordManager.getCurrentPath();
        this.projectDiagramServices.saveOrUpdate((Path)diagramPath, (ProjectDiagram)this.stunnerEditor.getDiagram(), this.metadata, commitMessage, new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.getSaveSuccessCallback(item.hashCode()).callback((Object)diagramPath);
                AbstractProjectDiagramEditor.this.onSaveSuccess();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onError(error);
            }
        });
    }

    private void saveAsXML(String commitMessage) {
        final ObservablePath diagramPath = this.versionRecordManager.getCurrentPath();
        this.projectDiagramServices.saveAsXml((Path)diagramPath, this.stunnerEditor.getXmlEditorView().getContent(), this.metadata, commitMessage, new ServiceCallback<String>(){

            public void onSuccess(String xml) {
                AbstractProjectDiagramEditor.this.getSaveSuccessCallback(xml.hashCode()).callback((Object)diagramPath);
                AbstractProjectDiagramEditor.this.showMessage(org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants.INSTANCE.ItemSavedSuccessfully());
                AbstractProjectDiagramEditor.this.onSaveSuccess();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onError(error);
            }
        });
    }

    protected void onSaveSuccess() {
        this.showMessage(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramSaveSuccessful"));
        this.stunnerEditor.resetContentHash();
        this.hideLoadingViews();
    }

    public RemoteCallback<Path> getSaveSuccessCallback(int newHash) {
        return path -> {
            this.versionRecordManager.reloadVersions(path);
            this.setOriginalHash(newHash);
        };
    }

    public void hideDocks() {
        super.hideDocks();
        this.onDiagramLostFocusEvent.fire((Object)new OnDiagramLoseFocusEvent());
    }

    public void showDocks() {
        this.onDiagramFocusEvent.fire((Object)new OnDiagramFocusEvent(this.getDockQualifiers()));
        super.showDocks();
    }

    protected Annotation[] getDockQualifiers() {
        return new Annotation[]{DefinitionManager.DEFAULT_QUALIFIER};
    }

    public abstract String getEditorIdentifier();

    protected Promise<Void> makeMenuBar() {
        if (!this.menuBarInitialized) {
            this.menuSessionItems.populateMenu(this.fileMenuBuilder);
            this.makeAdditionalStunnerMenus(this.fileMenuBuilder);
            if (this.workbenchContext.getActiveWorkspaceProject().isPresent()) {
                WorkspaceProject activeProject = (WorkspaceProject)this.workbenchContext.getActiveWorkspaceProject().get();
                return this.projectController.canUpdateProject(activeProject).then(canUpdateProject -> {
                    if (canUpdateProject.booleanValue()) {
                        ParameterizedCommand onSave = withComments -> {
                            this.saveWithComments = withComments;
                            this.saveAction();
                        };
                        this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(onSave)).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator).addRename(this.getSaveAndRename()).addDelete((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
                    }
                    this.addDownloadMenuItem(this.fileMenuBuilder);
                    this.fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
                    this.menuBarInitialized = true;
                    return this.promises.resolve();
                });
            }
        }
        return this.promises.resolve();
    }

    protected Command getSaveAndRename() {
        return super.getSaveAndRename();
    }

    protected ParameterizedCommand<Path> onSuccess() {
        return path -> {
            if (!this.stunnerEditor.isClosed()) {
                super.onSuccess().execute(path);
            }
        };
    }

    protected Caller<? extends SupportsSaveAndRename<ProjectDiagram, Metadata>> getSaveAndRenameServiceCaller() {
        return this.projectDiagramResourceServiceCaller;
    }

    protected Supplier<ProjectDiagram> getContentSupplier() {
        return () -> (ProjectDiagram)this.stunnerEditor.getCanvasHandler().getDiagram();
    }

    protected Integer getCurrentContentHash() {
        return this.stunnerEditor.getCurrentContentHash();
    }

    protected void doClose() {
        this.menuItems.clear();
        this.menuSessionItems.destroy();
        this.destroySession();
    }

    protected void showLoadingViews() {
        this.getView().showLoading();
    }

    protected void showSavingViews() {
        this.getView().showSaving();
    }

    protected void hideLoadingViews() {
        this.getView().hideBusyIndicator();
    }

    void onSessionErrorEvent(@Observes OnSessionErrorEvent errorEvent) {
        if (this.isSameSession(errorEvent.getSession())) {
            this.executeWithConfirm(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.OnErrorConfirmUndoLastAction", new Object[]{errorEvent.getError()}), () -> this.menuSessionItems.getCommands().getUndoSessionCommand().execute());
        }
    }

    protected boolean isSameSession(ClientSession other) {
        return null != other && null != this.getSession() && other.equals(this.getSession());
    }

    public String getTitleText() {
        return this.title;
    }

    protected void updateTitle(String title) {
        this.title = this.formatTitle(title);
        this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.title));
    }

    protected String formatTitle(String title) {
        if (Objects.isNull(this.resourceType)) {
            return title;
        }
        return TITLE_FORMAT_TEMPLATE.replace("#title", title).replace("#suffix", this.resourceType.getSuffix()).replace("#type", this.resourceType.getShortName());
    }

    private ClientSession getSession() {
        return this.stunnerEditor.getSession();
    }

    private void executeWithConfirm(String message, Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)message, null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    protected View getView() {
        return (View)this.baseView;
    }

    protected void destroySession() {
        this.stunnerEditor.close();
    }

    public void addDocumentationPage(ProjectDiagram diagram) {
        Optional.ofNullable(this.documentationView.isEnabled()).filter(Boolean.TRUE::equals).ifPresent(enabled -> {
            String label = this.translationService.getValue("Documentation");
            this.addPage((Page)new DocumentationPage(this.documentationView.initialize((Diagram)diagram), label, () -> this.onDiagramFocusEvent.fire((Object)new OnDiagramFocusEvent(this.getDockQualifiers())), () -> Objects.equals(2, this.kieView.getSelectedTabIndex())));
        });
    }

    public void onError(ClientRuntimeError error) {
        this.stunnerEditor.handleError(error);
        this.hideLoadingViews();
    }

    private void logMenuItemError(String message) {
        LOGGER.log(Level.WARNING, message);
        this.hideLoadingViews();
    }

    private void showMessage(String message) {
        if (this.stunnerEditor.isXmlEditorEnabled()) {
            this.notification.fire((Object)new NotificationEvent(message));
        } else {
            this.stunnerEditor.showMessage(message);
        }
    }

    public void setOriginalHash(Integer originalHash) {
        super.setOriginalHash(originalHash);
        this.stunnerEditor.resetContentHash();
    }

    protected boolean hasUnsavedChanges() {
        return super.isDirty(this.getCurrentContentHash());
    }

    protected ClientTranslationService getTranslationService() {
        return this.translationService;
    }

    protected void makeAdditionalStunnerMenus(FileMenuBuilder fileMenuBuilder) {
    }

    public AbstractDiagramEditorMenuSessionItems getMenuSessionItems() {
        return this.menuSessionItems;
    }

    public StunnerEditor getStunnerEditor() {
        return this.stunnerEditor;
    }

    public static interface View
    extends BaseEditorView,
    RequiresResize,
    ProvidesResize,
    IsWidget,
    KieEditorView {
        public void setWidget(IsWidget var1);
    }
}

