/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.user.client.Command;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.client.widgets.editor.EditorSessionCommands;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;

public class ValidationAction {
    private final EditorSessionCommands sessionCommands;
    private final Command loadingStarts;
    private final Command loadingCompleted;
    private final Consumer<String> onError;
    private boolean isValidationRunning = false;
    private Command onAfterValidation = null;
    private BooleanSupplier onBeforeValidation = null;

    public ValidationAction(EditorSessionCommands sessionCommands, Command loadingStarts, Command loadingCompleted, Consumer<String> onError) {
        this.sessionCommands = (EditorSessionCommands)PortablePreconditions.checkNotNull((String)"sessionCommands", (Object)sessionCommands);
        this.loadingStarts = (Command)PortablePreconditions.checkNotNull((String)"loadingStarts", (Object)loadingStarts);
        this.loadingCompleted = (Command)PortablePreconditions.checkNotNull((String)"loadingCompleted", (Object)loadingCompleted);
        this.onError = (Consumer)PortablePreconditions.checkNotNull((String)"onError", onError);
    }

    private boolean onBeforeValidate() {
        if (this.onBeforeValidation != null) {
            return this.onBeforeValidation.getAsBoolean();
        }
        return true;
    }

    private void onAfterValidation() {
        if (this.onAfterValidation != null) {
            this.onAfterValidation.execute();
        }
        this.isValidationRunning = false;
    }

    public void validate() {
        if (!this.isValidationRunning && this.onBeforeValidate()) {
            this.isValidationRunning = true;
            this.loadingStarts.execute();
            this.sessionCommands.getValidateSessionCommand().execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

                public void onSuccess() {
                    ValidationAction.this.loadingCompleted.execute();
                    ValidationAction.this.onAfterValidation();
                }

                public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                    ValidationAction.this.loadingCompleted.execute();
                    ValidationAction.this.onError.accept(violations.toString());
                    ValidationAction.this.onAfterValidation();
                }
            });
        }
    }

    public void setBeforeValidation(BooleanSupplier onBeforeValidation) {
        this.onBeforeValidation = onBeforeValidation;
    }

    public void setAfterValidation(Command onAfterValidation) {
        this.onAfterValidation = onAfterValidation;
    }
}

