/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.kie.workbench.common.stunner.client.widgets.menu.MenuUtils;
import org.kie.workbench.common.stunner.client.widgets.popups.PopupUtil;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class AbstractDiagramEditorMenuItemsBuilder {
    protected final ClientTranslationService translationService;
    protected final PopupUtil popupUtil;

    protected AbstractDiagramEditorMenuItemsBuilder() {
        this(null, null);
    }

    public AbstractDiagramEditorMenuItemsBuilder(ClientTranslationService translationService, PopupUtil popupUtil) {
        this.translationService = translationService;
        this.popupUtil = popupUtil;
    }

    public MenuItem newVisitGraphItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildVisitGraphItem(command));
    }

    private IsWidget buildVisitGraphItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.PLAY).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.VisitGraph")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newSwitchGridItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildSwitchGridItem(command));
    }

    private IsWidget buildSwitchGridItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.TH).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.SwitchGrid")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newClearItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildClearItem(command));
    }

    private IsWidget buildClearItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.ERASER).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram")).clickHandler(clickEvent -> this.executeWithConfirm(command, this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram"), this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram"), this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ConfirmClearDiagram"))).build());
    }

    public MenuItem newCopyItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildCopyItem(command));
    }

    private IsWidget buildCopyItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.COPY).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.CopySelection")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newPasteItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildPasteItem(command));
    }

    private IsWidget buildPasteItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.PASTE).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.PasteSelection")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newCutItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildCutItem(command));
    }

    private IsWidget buildCutItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.CUT).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.CutSelection")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newDeleteSelectionItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildDeleteSelectionItem(command));
    }

    private IsWidget buildDeleteSelectionItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.TRASH_O).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.DeleteSelection")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newUndoItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildUndoItem(command));
    }

    private IsWidget buildUndoItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.UNDO).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.Undo")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newRedoItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildRedoItem(command));
    }

    private IsWidget buildRedoItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.UNDO).styleName("fa-flip-horizontal").title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.Redo")).clickHandler(clickEvent -> command.execute()).build());
    }

    public MenuItem newExportsItem(Command exportPNGCommand, Command exportJPGCommand, Command exportSVGCommand, Command exportPDFCommand, Command exportAsRawCommand) {
        DropDownMenu menu = (DropDownMenu)GWT.create(DropDownMenu.class);
        menu.setPull(Pull.RIGHT);
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportPNG"), exportPNGCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportJPG"), exportJPGCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportSVG"), exportSVGCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportPDF"), exportPDFCommand));
        this.getExportLabelToRawFormatIfSupported().ifPresent(label -> menu.add((Widget)this.makeExportMenuItemWidget((String)label, exportAsRawCommand)));
        Button button = (Button)GWT.create(Button.class);
        ButtonGroup buttonGroup = (ButtonGroup)GWT.create(ButtonGroup.class);
        buttonGroup.add((Widget)button);
        buttonGroup.add((Widget)menu);
        button.setToggleCaret(true);
        button.setDataToggle(Toggle.DROPDOWN);
        button.setIcon(IconType.DOWNLOAD);
        button.setSize(ButtonSize.SMALL);
        button.setTitle(this.translationService.getValue("DownloadDiagram"));
        MenuUtils.HasEnabledIsWidget group = MenuUtils.buildHasEnabledWidget((ButtonGroup)buttonGroup, (Button)button);
        return AbstractDiagramEditorMenuItemsBuilder.buildItem((IsWidget)group);
    }

    private AnchorListItem makeExportMenuItemWidget(String caption, Command onClickCommand) {
        AnchorListItem exportMenuItemWidget = (AnchorListItem)GWT.create(AnchorListItem.class);
        exportMenuItemWidget.setIcon(IconType.FILE_IMAGE_O);
        exportMenuItemWidget.setIconPosition(IconPosition.LEFT);
        exportMenuItemWidget.setText(caption);
        exportMenuItemWidget.setTitle(caption);
        exportMenuItemWidget.addClickHandler(event -> onClickCommand.execute());
        return exportMenuItemWidget;
    }

    protected Optional<String> getExportLabelToRawFormatIfSupported() {
        return Optional.empty();
    }

    public MenuItem newValidateItem(Command command) {
        return AbstractDiagramEditorMenuItemsBuilder.buildItem(this.buildValidateItem(command));
    }

    private IsWidget buildValidateItem(Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new ButtonBuilder().size(ButtonSize.SMALL).icon(IconType.CHECK).title(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.Validate")).clickHandler(clickEvent -> command.execute()).build());
    }

    private void executeWithConfirm(Command command, String title, String okButtonText, String confirmMessage) {
        this.popupUtil.showConfirmPopup(title, okButtonText, confirmMessage, command);
    }

    public static MenuItem buildItem(IsWidget widget) {
        return MenuUtils.buildItem((IsWidget)widget);
    }

    public ClientTranslationService getTranslationService() {
        return this.translationService;
    }

    public PopupUtil getPopupUtil() {
        return this.popupUtil;
    }

    private static class ButtonBuilder {
        private Button result = new Button();

        public ButtonBuilder clickHandler(ClickHandler clickHandler) {
            this.result.addClickHandler(clickHandler);
            return this;
        }

        public ButtonBuilder icon(IconType icon) {
            this.result.setIcon(icon);
            return this;
        }

        public ButtonBuilder title(String title) {
            this.result.setTitle(title);
            return this;
        }

        public ButtonBuilder size(ButtonSize size) {
            this.result.setSize(size);
            return this;
        }

        public ButtonBuilder styleName(String styleName) {
            this.result.addStyleName(styleName);
            return this;
        }

        public Button build() {
            return this.result;
        }
    }
}

