/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import org.kie.workbench.common.stunner.client.widgets.editor.EditorSessionCommands;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CutSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToJpgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPdfSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPngSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToRawFormatSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToSvgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.PasteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RedoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SwitchGridSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.UndoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.VisitGraphSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.project.client.editor.AbstractDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.stunner.project.client.editor.ValidationAction;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class AbstractDiagramEditorMenuSessionItems<BUILDER extends AbstractDiagramEditorMenuItemsBuilder> {
    private final BUILDER itemsBuilder;
    private final Map<Class<? extends ClientSessionCommand>, MenuItem> menuItems;
    private final EditorSessionCommands sessionCommands;
    private Command loadingStarts;
    private Command loadingCompleted;
    private Consumer<String> errorConsumer;
    private ValidationAction validationAction;

    public AbstractDiagramEditorMenuSessionItems(BUILDER itemsBuilder, EditorSessionCommands sessionCommands) {
        this.itemsBuilder = itemsBuilder;
        this.sessionCommands = sessionCommands;
        this.validationAction = this.makeValidation();
        this.menuItems = new HashMap<Class<? extends ClientSessionCommand>, MenuItem>(20);
        this.loadingStarts = () -> {};
        this.loadingCompleted = () -> {};
        this.errorConsumer = e -> {};
    }

    protected ValidationAction makeValidation() {
        return new ValidationAction(this.sessionCommands, this::loadingStarts, this::loadingCompleted, this::onError);
    }

    public AbstractDiagramEditorMenuSessionItems<BUILDER> setLoadingStarts(Command loadingStarts) {
        this.loadingStarts = loadingStarts;
        return this;
    }

    public AbstractDiagramEditorMenuSessionItems<BUILDER> setLoadingCompleted(Command loadingCompleted) {
        this.loadingCompleted = loadingCompleted;
        return this;
    }

    public AbstractDiagramEditorMenuSessionItems<BUILDER> setErrorConsumer(Consumer<String> errorConsumer) {
        this.errorConsumer = errorConsumer;
        return this;
    }

    public void populateMenu(FileMenuBuilder menu) {
        MenuItem clearItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newClearItem(this::menu_clear);
        this.menuItems.put(ClearSessionCommand.class, clearItem);
        MenuItem visitGraphItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newVisitGraphItem(this::menu_visitGraph);
        this.menuItems.put(VisitGraphSessionCommand.class, visitGraphItem);
        MenuItem switchGridItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newSwitchGridItem(this::menu_switchGrid);
        this.menuItems.put(SwitchGridSessionCommand.class, switchGridItem);
        MenuItem deleteSelectionItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newDeleteSelectionItem(this::menu_deleteSelected);
        this.menuItems.put(DeleteSelectionSessionCommand.class, deleteSelectionItem);
        MenuItem undoItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newUndoItem(this::menu_undo);
        this.menuItems.put(UndoSessionCommand.class, undoItem);
        MenuItem redoItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newRedoItem(this::menu_redo);
        this.menuItems.put(RedoSessionCommand.class, redoItem);
        MenuItem validateItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newValidateItem(this::validate);
        this.menuItems.put(ValidateSessionCommand.class, validateItem);
        MenuItem exportsItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newExportsItem(this::export_imagePNG, this::export_imageJPG, this::export_imageSVG, this::export_imagePDF, this::export_fileRaw);
        this.menuItems.put(ExportToPngSessionCommand.class, exportsItem);
        this.menuItems.put(ExportToJpgSessionCommand.class, exportsItem);
        this.menuItems.put(ExportToSvgSessionCommand.class, exportsItem);
        this.menuItems.put(ExportToPdfSessionCommand.class, exportsItem);
        this.menuItems.put(ExportToRawFormatSessionCommand.class, exportsItem);
        MenuItem pasteItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newPasteItem(this::paste);
        this.menuItems.put(PasteSelectionSessionCommand.class, pasteItem);
        MenuItem copyItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newCopyItem(this::menu_copy);
        this.menuItems.put(CopySelectionSessionCommand.class, copyItem);
        MenuItem cutItem = ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).newCutItem(this::menu_cut);
        this.menuItems.put(CutSelectionSessionCommand.class, cutItem);
        menu.addNewTopLevelMenu(clearItem).addNewTopLevelMenu(visitGraphItem).addNewTopLevelMenu(switchGridItem).addNewTopLevelMenu(deleteSelectionItem).addNewTopLevelMenu(undoItem).addNewTopLevelMenu(redoItem).addNewTopLevelMenu(validateItem).addNewTopLevelMenu(exportsItem).addNewTopLevelMenu(copyItem).addNewTopLevelMenu(cutItem).addNewTopLevelMenu(pasteItem);
    }

    public void bind(ClientSession session) {
        this.sessionCommands.bind(session).getCommands().visit((type, command) -> command.listen(() -> Optional.ofNullable(this.menuItems.get(type)).ifPresent(item -> item.setEnabled(command.isEnabled()))));
        this.setEnabled(session instanceof EditorSession);
    }

    public void setEnabled(boolean enabled) {
        this.setItemEnabled(ClearSessionCommand.class, enabled);
        this.setItemEnabled(VisitGraphSessionCommand.class, enabled);
        this.setItemEnabled(SwitchGridSessionCommand.class, enabled);
        this.setItemEnabled(ValidateSessionCommand.class, enabled);
        this.setItemEnabled(ExportToJpgSessionCommand.class, enabled);
        this.setItemEnabled(ExportToPngSessionCommand.class, enabled);
        this.setItemEnabled(ExportToSvgSessionCommand.class, enabled);
        this.setItemEnabled(ExportToPdfSessionCommand.class, enabled);
        this.setItemEnabled(ExportToRawFormatSessionCommand.class, enabled);
        this.setItemEnabled(DeleteSelectionSessionCommand.class, false);
        this.setItemEnabled(UndoSessionCommand.class, false);
        this.setItemEnabled(RedoSessionCommand.class, false);
        this.setItemEnabled(CopySelectionSessionCommand.class, false);
        this.setItemEnabled(CutSelectionSessionCommand.class, false);
        this.setItemEnabled(PasteSelectionSessionCommand.class, false);
    }

    public EditorSessionCommands getCommands() {
        return this.sessionCommands;
    }

    public ClientTranslationService getTranslationService() {
        return ((AbstractDiagramEditorMenuItemsBuilder)this.itemsBuilder).getTranslationService();
    }

    @PreDestroy
    public void destroy() {
        this.sessionCommands.getCommands().visit((type, command) -> command.listen(null));
        this.menuItems.clear();
        this.loadingStarts = null;
        this.loadingCompleted = null;
        this.errorConsumer = null;
    }

    protected void addMenuItem(Class clazz, MenuItem menuItem) {
        this.menuItems.put(clazz, menuItem);
    }

    private void validate() {
        this.validationAction.validate();
    }

    public void setItemEnabled(Class<? extends ClientSessionCommand> type, boolean enabled) {
        if (this.menuItems.containsKey(type)) {
            this.menuItems.get(type).setEnabled(enabled);
        }
    }

    public boolean isItemEnabled(Class<? extends ClientSessionCommand> type) {
        return this.menuItems.containsKey(type) && this.menuItems.get(type).isEnabled();
    }

    private void menu_clear() {
        this.sessionCommands.getClearSessionCommand().execute();
    }

    private void menu_visitGraph() {
        this.sessionCommands.getVisitGraphSessionCommand().execute();
    }

    private void menu_switchGrid() {
        this.sessionCommands.getSwitchGridSessionCommand().execute();
    }

    private void menu_deleteSelected() {
        this.sessionCommands.getDeleteSelectionSessionCommand().execute();
    }

    private void menu_undo() {
        this.sessionCommands.getUndoSessionCommand().execute();
    }

    private void menu_redo() {
        this.sessionCommands.getRedoSessionCommand().execute();
    }

    private void export_imagePNG() {
        this.sessionCommands.getExportToPngSessionCommand().execute();
    }

    private void export_imageJPG() {
        this.sessionCommands.getExportToJpgSessionCommand().execute();
    }

    private void export_imagePDF() {
        this.sessionCommands.getExportToPdfSessionCommand().execute();
    }

    private void paste() {
        this.sessionCommands.getPasteSelectionSessionCommand().execute();
    }

    private void export_imageSVG() {
        this.sessionCommands.getExportToSvgSessionCommand().execute();
    }

    private void export_fileRaw() {
        this.sessionCommands.getExportToRawFormatSessionCommand().execute();
    }

    private void menu_copy() {
        this.sessionCommands.getCopySelectionSessionCommand().execute();
    }

    private void menu_cut() {
        this.sessionCommands.getCutSelectionSessionCommand().execute();
    }

    protected void loadingStarts() {
        this.loadingStarts.execute();
    }

    protected void loadingCompleted() {
        this.loadingCompleted.execute();
    }

    protected void onError(String error) {
        this.errorConsumer.accept(error);
    }
}

