/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenterFactory;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearStatesSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CutSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToBpmnSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToJpgSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPdfSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ExportToPngSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.PasteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RedoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SessionCommandFactory;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SwitchGridSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.UndoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.VisitGraphSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.core.validation.impl.ValidationUtils;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.AbstractPlaceEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractProjectDiagramEditor<R extends ClientResourceType>
extends KieEditor<ProjectDiagram> {
    private static Logger LOGGER = Logger.getLogger(AbstractProjectDiagramEditor.class.getName());
    private static final String TITLE_FORMAT_TEMPLATE = "#title.#suffix - #type";
    private PlaceManager placeManager;
    private ErrorPopupPresenter errorPopupPresenter;
    private Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private R resourceType;
    private ClientProjectDiagramService projectDiagramServices;
    private SessionManager sessionManager;
    private SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory;
    private SessionCommandFactory sessionCommandFactory;
    private ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder;
    private ProjectMessagesListener projectMessagesListener;
    private Map<Class, ClientSessionCommand> commands;
    private Event<OnDiagramFocusEvent> onDiagramFocusEvent;
    private Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent;
    protected SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter;
    private final DiagramClientErrorHandler diagramClientErrorHandler;
    private final ClientTranslationService translationService;
    private String title = "Project Diagram Editor";

    @Inject
    public AbstractProjectDiagramEditor(View view, PlaceManager placeManager, ErrorPopupPresenter errorPopupPresenter, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SavePopUpPresenter savePopUpPresenter, R resourceType, ClientProjectDiagramService projectDiagramServices, SessionManager sessionManager, SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory, SessionCommandFactory sessionCommandFactory, ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, ProjectMessagesListener projectMessagesListener, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService) {
        super((KieEditorView)view);
        this.placeManager = placeManager;
        this.errorPopupPresenter = errorPopupPresenter;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
        this.savePopUpPresenter = savePopUpPresenter;
        this.resourceType = resourceType;
        this.projectDiagramServices = projectDiagramServices;
        this.sessionManager = sessionManager;
        this.sessionPresenterFactory = sessionPresenterFactory;
        this.sessionCommandFactory = sessionCommandFactory;
        this.menuItemsBuilder = menuItemsBuilder;
        this.projectMessagesListener = projectMessagesListener;
        this.diagramClientErrorHandler = diagramClientErrorHandler;
        this.onDiagramFocusEvent = onDiagramFocusEvent;
        this.onDiagramLostFocusEvent = onDiagramLostFocusEvent;
        this.translationService = translationService;
        this.commands = new HashMap<Class, ClientSessionCommand>();
    }

    protected abstract int getCanvasWidth();

    protected abstract int getCanvasHeight();

    @PostConstruct
    public void init() {
        this.initializeCommands(this.commands);
        this.title = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramEditorDefaultTitle");
        this.getView().init((Object)this);
        this.projectMessagesListener.enable();
    }

    protected void doStartUp(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.resourceType);
    }

    protected void loadContent() {
        this.projectDiagramServices.getByPath((Path)this.versionRecordManager.getCurrentPath(), (ServiceCallback)new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.open(item);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onLoadError(error);
            }
        });
    }

    protected void open(final ProjectDiagram diagram) {
        this.showLoadingViews();
        this.setOriginalHash(diagram.hashCode());
        Metadata metadata = diagram.getMetadata();
        this.sessionManager.getSessionFactory(metadata, ClientFullSession.class).newSession(metadata, s -> {
            AbstractClientFullSession session = (AbstractClientFullSession)s;
            this.presenter = this.sessionPresenterFactory.newPresenterEditor();
            this.getView().setWidget(this.presenter.getView());
            this.presenter.withToolbar(false).withPalette(true).displayNotifications(type -> true).open((Diagram)diagram, (ClientSession)session, (SessionPresenter.SessionPresenterCallback)new SessionPresenter.SessionPresenterCallback<AbstractClientFullSession, Diagram>(){

                public void afterSessionOpened() {
                }

                public void afterCanvasInitialized() {
                }

                public void onSuccess() {
                    AbstractProjectDiagramEditor.this.bindCommands();
                    AbstractProjectDiagramEditor.this.updateTitle(((ProjectMetadata)diagram.getMetadata()).getTitle());
                    AbstractProjectDiagramEditor.this.hideLoadingViews();
                    AbstractProjectDiagramEditor.this.setOriginalHash(AbstractProjectDiagramEditor.this.getCurrentDiagramHash());
                }

                public void onError(ClientRuntimeError error) {
                    AbstractProjectDiagramEditor.this.onLoadError(error);
                }
            });
        });
    }

    protected Command onValidate() {
        return () -> this.validate(() -> {
            this.onValidationSuccess();
            this.hideLoadingViews();
        });
    }

    protected void save() {
        final Command continueSaveOnceValid = () -> super.save();
        this.getCommand(ValidateSessionCommand.class).execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                continueSaveOnceValid.execute();
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                Violation.Type maxSeverity = ValidationUtils.getMaxSeverity(violations);
                if (maxSeverity.equals((Object)Violation.Type.ERROR)) {
                    AbstractProjectDiagramEditor.this.onValidationFailed(violations);
                } else {
                    continueSaveOnceValid.execute();
                }
            }
        });
    }

    protected void save(String commitMessage) {
        super.save(commitMessage);
        this.showLoadingViews();
        AbstractCanvasHandler canvasHandler = this.getSession().getCanvasHandler();
        Diagram diagram = canvasHandler.getDiagram();
        this.projectDiagramServices.saveOrUpdate((Path)this.versionRecordManager.getCurrentPath(), this.getDiagram(), this.metadata, commitMessage, new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.getSaveSuccessCallback(item.hashCode());
                AbstractProjectDiagramEditor.this.onSaveSuccess();
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onSaveError(error);
            }
        });
    }

    public void hideDiagramEditorDocks(@Observes PlaceHiddenEvent event) {
        if (this.verifyEventIdentifier((AbstractPlaceEvent)event)) {
            this.onDiagramLostFocusEvent.fire((Object)new OnDiagramLoseFocusEvent());
        }
    }

    public void showDiagramEditorDocks(@Observes PlaceGainFocusEvent event) {
        if (this.verifyEventIdentifier((AbstractPlaceEvent)event)) {
            this.onDiagramFocusEvent.fire((Object)new OnDiagramFocusEvent());
        }
    }

    protected void makeMenuBar() {
        MenuItem clearItem = this.menuItemsBuilder.newClearItem(this::menu_clear);
        this.getCommand(ClearSessionCommand.class).listen(() -> clearItem.setEnabled(this.getCommand(ClearSessionCommand.class).isEnabled()));
        MenuItem visitGraphItem = this.menuItemsBuilder.newVisitGraphItem(this::menu_visitGraph);
        this.getCommand(VisitGraphSessionCommand.class).listen(() -> visitGraphItem.setEnabled(this.getCommand(VisitGraphSessionCommand.class).isEnabled()));
        MenuItem switchGridItem = this.menuItemsBuilder.newSwitchGridItem(this::menu_switchGrid);
        this.getCommand(SwitchGridSessionCommand.class).listen(() -> switchGridItem.setEnabled(this.getCommand(SwitchGridSessionCommand.class).isEnabled()));
        MenuItem deleteSelectionItem = this.menuItemsBuilder.newDeleteSelectionItem(this::menu_deleteSelected);
        this.getCommand(DeleteSelectionSessionCommand.class).listen(() -> deleteSelectionItem.setEnabled(this.getCommand(DeleteSelectionSessionCommand.class).isEnabled()));
        MenuItem undoItem = this.menuItemsBuilder.newUndoItem(this::menu_undo);
        this.getCommand(UndoSessionCommand.class).listen(() -> undoItem.setEnabled(this.getCommand(UndoSessionCommand.class).isEnabled()));
        MenuItem redoItem = this.menuItemsBuilder.newRedoItem(this::menu_redo);
        this.getCommand(RedoSessionCommand.class).listen(() -> redoItem.setEnabled(this.getCommand(RedoSessionCommand.class).isEnabled()));
        MenuItem validateItem = this.menuItemsBuilder.newValidateItem(() -> this.validate(() -> this.hideLoadingViews()));
        this.getCommand(ValidateSessionCommand.class).listen(() -> validateItem.setEnabled(this.getCommand(ValidateSessionCommand.class).isEnabled()));
        MenuItem exportsItem = this.menuItemsBuilder.newExportsItem(this::export_imagePNG, this::export_imageJPG, this::export_imagePDF, this::export_fileBPMN);
        this.getCommand(ExportToPngSessionCommand.class).listen(() -> exportsItem.setEnabled(this.getCommand(ExportToPngSessionCommand.class).isEnabled()));
        this.getCommand(ExportToJpgSessionCommand.class).listen(() -> exportsItem.setEnabled(this.getCommand(ExportToJpgSessionCommand.class).isEnabled()));
        this.getCommand(ExportToPdfSessionCommand.class).listen(() -> exportsItem.setEnabled(this.getCommand(ExportToPdfSessionCommand.class).isEnabled()));
        this.getCommand(ExportToBpmnSessionCommand.class).listen(() -> exportsItem.setEnabled(this.getCommand(ExportToBpmnSessionCommand.class).isEnabled()));
        MenuItem pasteItem = this.menuItemsBuilder.newPasteItem(() -> this.getCommand(PasteSelectionSessionCommand.class).execute());
        this.getCommand(PasteSelectionSessionCommand.class).listen(() -> pasteItem.setEnabled(this.getCommand(PasteSelectionSessionCommand.class).isEnabled()));
        MenuItem copyItem = this.menuItemsBuilder.newCopyItem(this::menu_copy);
        this.getCommand(CopySelectionSessionCommand.class).listen(() -> copyItem.setEnabled(this.getCommand(CopySelectionSessionCommand.class).isEnabled()));
        MenuItem cutItem = this.menuItemsBuilder.newCutItem(this::menu_cut);
        this.getCommand(CutSelectionSessionCommand.class).listen(() -> cutItem.setEnabled(this.getCommand(CutSelectionSessionCommand.class).isEnabled()));
        deleteSelectionItem.setEnabled(false);
        undoItem.setEnabled(false);
        redoItem.setEnabled(false);
        copyItem.setEnabled(false);
        cutItem.setEnabled(false);
        pasteItem.setEnabled(false);
        this.fileMenuBuilder.addNewTopLevelMenu(clearItem).addNewTopLevelMenu(visitGraphItem).addNewTopLevelMenu(switchGridItem).addNewTopLevelMenu(deleteSelectionItem).addNewTopLevelMenu(undoItem).addNewTopLevelMenu(redoItem).addNewTopLevelMenu(validateItem).addNewTopLevelMenu(exportsItem).addNewTopLevelMenu(copyItem).addNewTopLevelMenu(cutItem).addNewTopLevelMenu(pasteItem);
        this.makeAdditionalStunnerMenus(this.fileMenuBuilder);
        if (this.menuItemsBuilder.isDevItemsEnabled()) {
            this.fileMenuBuilder.addNewTopLevelMenu(this.menuItemsBuilder.newDevItems());
        }
        if (this.canUpdateProject()) {
            this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(() -> this.saveAction())).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator).addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator).addDelete((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
        }
        this.fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    protected <T> T getCommand(Class<T> key) {
        return (T)this.commands.get(key);
    }

    private void validate(final Command callback) {
        this.showLoadingViews();
        this.getCommand(ValidateSessionCommand.class).execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                callback.execute();
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                AbstractProjectDiagramEditor.this.onValidationFailed(violations);
            }
        });
    }

    private void menu_clear() {
        this.getCommand(ClearSessionCommand.class).execute();
    }

    private void menu_visitGraph() {
        this.getCommand(VisitGraphSessionCommand.class).execute();
    }

    private void menu_switchGrid() {
        this.getCommand(SwitchGridSessionCommand.class).execute();
    }

    private void menu_deleteSelected() {
        this.getCommand(DeleteSelectionSessionCommand.class).execute();
    }

    private void menu_undo() {
        this.getCommand(UndoSessionCommand.class).execute();
    }

    private void menu_redo() {
        this.getCommand(RedoSessionCommand.class).execute();
    }

    private void export_imagePNG() {
        this.getCommand(ExportToPngSessionCommand.class).execute();
    }

    private void export_imageJPG() {
        this.getCommand(ExportToJpgSessionCommand.class).execute();
    }

    private void export_imagePDF() {
        this.getCommand(ExportToPdfSessionCommand.class).execute();
    }

    private void export_fileBPMN() {
        this.getCommand(ExportToBpmnSessionCommand.class).execute();
    }

    private void menu_copy() {
        this.getCommand(CopySelectionSessionCommand.class).execute();
    }

    private void menu_cut() {
        this.getCommand(CutSelectionSessionCommand.class).execute();
    }

    protected void doOpen() {
        if (null != this.getSession()) {
            this.sessionManager.resume((ClientSession)this.getSession());
        }
    }

    protected void showLoadingViews() {
        this.getView().showLoading();
    }

    protected void hideLoadingViews() {
        this.getView().hideBusyIndicator();
    }

    protected void doClose() {
        this.destroySession();
    }

    protected void doFocus() {
        this.log(Level.FINE, "Focusing Stunner Project Diagram Editor...");
        if (null != this.getSession() && !this.isSameSession(this.sessionManager.getCurrentSession())) {
            this.sessionManager.open((ClientSession)this.getSession());
        } else if (null != this.getSession()) {
            this.log(Level.FINE, "Session already active, no action.");
        }
    }

    protected void doLostFocus() {
    }

    void onSessionErrorEvent(@Observes OnSessionErrorEvent errorEvent) {
        if (this.isSameSession(errorEvent.getSession())) {
            this.executeWithConfirm(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.OnErrorConfirmUndoLastAction", new Object[]{errorEvent.getError()}), this::menu_undo);
        }
    }

    private boolean isSameSession(ClientSession other) {
        return null != other && null != this.getSession() && other.equals(this.getSession());
    }

    protected abstract String getEditorIdentifier();

    public String getTitleText() {
        return this.title;
    }

    protected Menus getMenus() {
        if (this.menus == null) {
            this.makeMenuBar();
        }
        return this.menus;
    }

    protected boolean _onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentDiagramHash()));
    }

    protected void onSave() {
        if (this.hasUnsavedChanges()) {
            super.onSave();
        } else {
            String message = CommonConstants.INSTANCE.NoChangesSinceLastSave();
            this.log(Level.INFO, message);
            ((SessionPresenter.View)this.presenter.getView()).showMessage(message);
        }
    }

    void bindCommands() {
        this.commands.values().stream().forEach(command -> command.bind((ClientSession)this.getSession()));
    }

    void unbindCommands() {
        this.commands.values().stream().forEach(CanvasControl.SessionAware::unbind);
    }

    private void pauseSession() {
        this.sessionManager.pause();
    }

    private void destroySession() {
        this.unbindCommands();
        if (Objects.nonNull(this.presenter)) {
            this.presenter.destroy();
        }
    }

    private void updateTitle(String title) {
        this.title = this.formatTitle(title);
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, this.title));
    }

    protected String formatTitle(String title) {
        if (Objects.isNull(this.resourceType)) {
            return title;
        }
        return TITLE_FORMAT_TEMPLATE.replace("#title", title).replace("#suffix", this.resourceType.getSuffix()).replace("#type", this.resourceType.getShortName());
    }

    private AbstractClientFullSession getSession() {
        return null != this.presenter ? (AbstractClientFullSession)this.presenter.getInstance() : null;
    }

    protected int getCurrentDiagramHash() {
        if (null == this.getDiagram()) {
            return 0;
        }
        int hash = this.getDiagram().hashCode();
        if (null == this.getCanvasHandler() || null == this.getCanvasHandler().getCanvas() || null == this.getCanvasHandler().getCanvas().getShapes()) {
            return hash;
        }
        List collectionOfShapes = this.getCanvasHandler().getCanvas().getShapes();
        ArrayList shapes = new ArrayList();
        shapes.addAll(collectionOfShapes);
        shapes.sort((a, b) -> a.getShapeView().getShapeX() == b.getShapeView().getShapeX() ? (int)Math.round(a.getShapeView().getShapeY() - b.getShapeView().getShapeY()) : (int)Math.round(a.getShapeView().getShapeX() - b.getShapeView().getShapeX()));
        for (Shape shape : shapes) {
            hash = HashUtil.combineHashCodes((int[])new int[]{hash, Double.hashCode(shape.getShapeView().getShapeX()), Double.hashCode(shape.getShapeView().getShapeY())});
        }
        return hash;
    }

    protected CanvasHandler getCanvasHandler() {
        return null != this.sessionManager.getCurrentSession() ? this.sessionManager.getCurrentSession().getCanvasHandler() : null;
    }

    protected ProjectDiagram getDiagram() {
        return null != this.getCanvasHandler() ? (ProjectDiagram)this.getCanvasHandler().getDiagram() : null;
    }

    private void executeWithConfirm(String message, Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)message, null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    protected View getView() {
        return (View)this.baseView;
    }

    protected void onSaveSuccess() {
        String message = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramSaveSuccessful");
        this.log(Level.INFO, message);
        ((SessionPresenter.View)this.presenter.getView()).showMessage(message);
        this.setOriginalHash(this.getCurrentDiagramHash());
    }

    protected void onSaveError(ClientRuntimeError error) {
        this.showError(error);
    }

    private void onValidationSuccess() {
        this.log(Level.INFO, "Validation SUCCESS.");
    }

    private void onValidationFailed(Collection<DiagramElementViolation<RuleViolation>> violations) {
        this.log(Level.WARNING, "Validation FAILED [violations=" + violations.toString() + "]");
        this.hideLoadingViews();
    }

    private void onLoadError(ClientRuntimeError error) {
        this.showError(error);
        this.placeManager.forceClosePlace((PlaceRequest)new PathPlaceRequest((Path)this.versionRecordManager.getCurrentPath(), this.getEditorIdentifier()));
    }

    protected void showError(ClientRuntimeError error) {
        this.diagramClientErrorHandler.handleError(error, message -> this.showError((String)message));
        this.log(Level.SEVERE, error.toString());
    }

    protected void showError(String message) {
        this.errorPopupPresenter.showMessage(message);
        this.hideLoadingViews();
    }

    protected void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    protected boolean hasUnsavedChanges() {
        return this.getCurrentDiagramHash() != this.originalHash.intValue();
    }

    private boolean verifyEventIdentifier(AbstractPlaceEvent event) {
        return Objects.equals(this.getEditorIdentifier(), event.getPlace().getIdentifier()) && Objects.equals(this.place, event.getPlace());
    }

    protected ClientTranslationService getTranslationService() {
        return this.translationService;
    }

    protected void makeAdditionalStunnerMenus(FileMenuBuilder fileMenuBuilder) {
    }

    protected void initializeCommands(Map<Class, ClientSessionCommand> commands) {
        commands.put(ClearStatesSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newClearStatesCommand());
        commands.put(VisitGraphSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newVisitGraphCommand());
        commands.put(SwitchGridSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newSwitchGridCommand());
        commands.put(ClearSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newClearCommand());
        commands.put(DeleteSelectionSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newDeleteSelectedElementsCommand());
        commands.put(UndoSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newUndoCommand());
        commands.put(RedoSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newRedoCommand());
        commands.put(ValidateSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newValidateCommand());
        commands.put(ExportToPngSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newExportToPngSessionCommand());
        commands.put(ExportToJpgSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newExportToJpgSessionCommand());
        commands.put(ExportToPdfSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newExportToPdfSessionCommand());
        commands.put(ExportToBpmnSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newExportToBpmnSessionCommand());
        commands.put(CopySelectionSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newCopySelectionCommand());
        commands.put(PasteSelectionSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newPasteSelectionCommand());
        commands.put(CutSelectionSessionCommand.class, (ClientSessionCommand)this.sessionCommandFactory.newCutSelectionCommand());
    }

    public SessionPresenter<AbstractClientFullSession, ?, Diagram> getSessionPresenter() {
        return this.presenter;
    }

    void setSessionPresenter(SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter) {
        this.presenter = presenter;
    }

    public static interface View
    extends UberView<AbstractProjectDiagramEditor>,
    KieEditorView,
    IsWidget {
        public void setWidget(IsWidget var1);
    }
}

