/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.handlers;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.type.ResourceTypeDefinition;

public abstract class AbstractProjectDiagramNewResourceHandler<R extends ClientResourceType>
extends DefaultNewResourceHandler {
    private static Logger LOGGER = Logger.getLogger(AbstractProjectDiagramNewResourceHandler.class.getName());
    private final DefinitionManager definitionManager;
    private final ClientProjectDiagramService projectDiagramServices;
    private final BusyIndicatorView indicatorView;
    private final R projectDiagramResourceType;

    public AbstractProjectDiagramNewResourceHandler(DefinitionManager definitionManager, ClientProjectDiagramService projectDiagramServices, BusyIndicatorView indicatorView, R projectDiagramResourceType) {
        this.definitionManager = definitionManager;
        this.projectDiagramServices = projectDiagramServices;
        this.indicatorView = indicatorView;
        this.projectDiagramResourceType = projectDiagramResourceType;
    }

    protected abstract Class<?> getDefinitionSetType();

    protected abstract String getEditorIdentifier();

    public ResourceTypeDefinition getResourceType() {
        return this.projectDiagramResourceType;
    }

    public void create(Package pkg, String name, final NewResourcePresenter presenter) {
        this.indicatorView.showBusyIndicator("Loading...");
        Path path = pkg.getPackageMainResourcesPath();
        Class<?> type = this.getDefinitionSetType();
        String setId = this.getId(type);
        String moduleName = this.context.getActiveModule().isPresent() ? ((Module)this.context.getActiveModule().get()).getModuleName() : "";
        this.projectDiagramServices.create(path, name, setId, moduleName, pkg, new ServiceCallback<Path>(){

            public void onSuccess(Path path) {
                AbstractProjectDiagramNewResourceHandler.this.indicatorView.hideBusyIndicator();
                presenter.complete();
                AbstractProjectDiagramNewResourceHandler.this.notifySuccess();
                AbstractProjectDiagramNewResourceHandler.this.newResourceSuccessEvent.fire((Object)new NewResourceSuccessEvent(path));
                PathPlaceRequest place = new PathPlaceRequest(path, AbstractProjectDiagramNewResourceHandler.this.getEditorIdentifier());
                AbstractProjectDiagramNewResourceHandler.this.placeManager.goTo((PlaceRequest)place);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramNewResourceHandler.this.showError(error);
            }
        });
    }

    private String getId(Class<?> type) {
        Object set = this.definitionManager.definitionSets().getDefinitionSetByType(type);
        return this.definitionManager.adapters().forDefinitionSet().getId(set);
    }

    private void showError(ClientRuntimeError error) {
        String msg = error.toString();
        this.log(Level.SEVERE, msg);
        ErrorPopup.showMessage((String)msg);
        this.indicatorView.hideBusyIndicator();
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

