/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.client.widgets.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.client.widgets.explorer.tree.TreeExplorer;
import org.kie.workbench.common.stunner.client.widgets.presenters.Viewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenterFactory;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPreview;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProjectDiagramExplorerScreen")
public class ProjectDiagramExplorerScreen {
    public static final String SCREEN_ID = "ProjectDiagramExplorerScreen";
    public static final String TITLE = "Explore";
    public static final int PREVIEW_WIDTH = 350;
    public static final int PREVIEW_HEIGHT = 175;
    private static Logger LOGGER = Logger.getLogger(ProjectDiagramExplorerScreen.class.getName());
    private final AbstractClientSessionManager clientSessionManager;
    private final TreeExplorer treeExplorer;
    private final SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private final ErrorPopupPresenter errorPopupPresenter;
    private final View view;
    private SessionPreview<AbstractClientSession, Diagram> sessionPreview;
    private PlaceRequest placeRequest;
    private String title = "Explore";

    protected ProjectDiagramExplorerScreen() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public ProjectDiagramExplorerScreen(AbstractClientSessionManager clientSessionManager, TreeExplorer treeExplorer, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory, ErrorPopupPresenter errorPopupPresenter, View view) {
        this.clientSessionManager = clientSessionManager;
        this.treeExplorer = treeExplorer;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
        this.sessionPresenterFactory = sessionPresenterFactory;
        this.errorPopupPresenter = errorPopupPresenter;
        this.view = view;
        this.sessionPreview = null;
    }

    @PostConstruct
    public void init() {
        this.view.setExplorerWidget((IsWidget)this.treeExplorer.asWidget());
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
    }

    @OnOpen
    public void onOpen() {
        ClientSession current = this.clientSessionManager.getCurrentSession();
        if (null != current) {
            this.show(current);
        }
    }

    @OnClose
    public void onClose() {
        this.close();
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return null;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "projectDiagramExplorerScreenContext";
    }

    public void show(ClientSession session) {
        if (null != session.getCanvasHandler().getDiagram()) {
            this.showPreview(session);
            this.showExplorer(session);
            this.updateTitle(session);
        }
    }

    public void close() {
        this.clearPreview();
        this.clearExplorer();
    }

    void onCanvasSessionOpened(@Observes SessionOpenedEvent sessionOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionOpenedEvent", (Object)sessionOpenedEvent);
        this.show(sessionOpenedEvent.getSession());
    }

    void onCanvasSessionDestroyed(@Observes SessionDestroyedEvent sessionDestroyedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDestroyedEvent", (Object)sessionDestroyedEvent);
        this.close();
    }

    void onSessionDiagramOpenedEvent(@Observes SessionDiagramOpenedEvent sessionDiagramOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDiagramOpenedEvent", (Object)sessionDiagramOpenedEvent);
        this.show(sessionDiagramOpenedEvent.getSession());
    }

    private void showExplorer(ClientSession session) {
        this.treeExplorer.show(session.getCanvasHandler());
    }

    private void showPreview(ClientSession session) {
        if (null != session && session instanceof AbstractClientSession) {
            this.sessionPreview = this.sessionPresenterFactory.newPreview();
            this.sessionPreview.open((Object)((AbstractClientSession)session), 350, 175, (Viewer.Callback)new SessionViewer.SessionViewerCallback<AbstractClientSession, Diagram>(){

                public void afterCanvasInitialized() {
                }

                public void onSuccess() {
                    ProjectDiagramExplorerScreen.this.view.setPreviewWidget(ProjectDiagramExplorerScreen.this.sessionPreview.getView());
                    ProjectDiagramExplorerScreen.this.updateTitle();
                }

                public void onError(ClientRuntimeError error) {
                    ProjectDiagramExplorerScreen.this.showError(error);
                }
            });
        }
    }

    private void clearExplorer() {
        this.treeExplorer.clear();
        this.treeExplorer.destroy();
    }

    private void clearPreview() {
        if (null != this.sessionPreview) {
            this.sessionPreview.destroy();
            this.sessionPreview = null;
        }
    }

    private void updateTitle() {
        ClientSession session = this.clientSessionManager.getCurrentSession();
        this.updateTitle(session);
    }

    private void updateTitle(ClientSession session) {
        String title = TITLE;
        if (null != session.getCanvasHandler() && null != session.getCanvasHandler().getDiagram()) {
            Diagram diagram = session.getCanvasHandler().getDiagram();
            title = diagram.getMetadata().getTitle();
        }
        this.doUpdateTitle(title);
    }

    private void doUpdateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, this.title));
    }

    private void showError(ClientRuntimeError error) {
        String s = error.toString();
        this.errorPopupPresenter.showMessage(s);
        LOGGER.log(Level.SEVERE, s);
    }

    public static interface View
    extends IsWidget {
        public View setPreviewWidget(IsWidget var1);

        public View setExplorerWidget(IsWidget var1);

        public View clear();
    }
}

