/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.forms.client.event.FormPropertiesOpened;
import org.kie.workbench.common.stunner.forms.client.widgets.FormPropertiesWidget;
import org.kie.workbench.common.stunner.project.client.view.ProjectScreenView;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProjectDiagramPropertiesScreen")
public class ProjectDiagramPropertiesScreen {
    private static Logger LOGGER = Logger.getLogger(ProjectDiagramPropertiesScreen.class.getName());
    public static final String SCREEN_ID = "ProjectDiagramPropertiesScreen";
    private final FormPropertiesWidget formPropertiesWidget;
    private final AbstractClientSessionManager clientSessionManager;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private final ProjectScreenView view;
    private PlaceRequest placeRequest;
    private ClientSession session;
    private String title = "Properties";

    protected ProjectDiagramPropertiesScreen() {
        this(null, null, null, null);
    }

    @Inject
    public ProjectDiagramPropertiesScreen(FormPropertiesWidget formPropertiesWidget, AbstractClientSessionManager clientSessionManager, Event<ChangeTitleWidgetEvent> changeTitleNotification, ProjectScreenView view) {
        this.formPropertiesWidget = formPropertiesWidget;
        this.clientSessionManager = clientSessionManager;
        this.changeTitleNotificationEvent = changeTitleNotification;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.setWidget((IsWidget)ElementWrapperWidget.getWidget((HTMLElement)this.formPropertiesWidget.getElement()));
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
    }

    @OnOpen
    public void onOpen() {
        this.log(Level.INFO, "Opening ProjectDiagramPropertiesScreen.");
        ClientSession current = this.clientSessionManager.getCurrentSession();
        this.handleSession(current);
    }

    @OnClose
    public void onClose() {
        this.log(Level.INFO, "Closing ProjectDiagramPropertiesScreen.");
        this.handleSession(null);
    }

    private void handleSession(ClientSession session) {
        boolean done = false;
        this.view.showLoading();
        if (null != session) {
            this.session = session;
            try {
                AbstractClientFullSession fullSession = (AbstractClientFullSession)session;
                this.view.showLoading();
                this.formPropertiesWidget.bind((ClientSession)fullSession).show(() -> this.view.hideLoading());
                done = true;
            }
            catch (ClassCastException e) {
                this.log(Level.INFO, "Session discarded for opening as not instance of full session.");
            }
        }
        if (!done) {
            this.formPropertiesWidget.unbind();
            this.view.hideLoading();
            this.session = null;
        }
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return null;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.formPropertiesWidget.getElement());
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "projectDiagramPropertiesScreenContext";
    }

    void onFormPropertiesOpened(@Observes FormPropertiesOpened propertiesOpened) {
        if (null != this.session && this.session.equals(propertiesOpened.getSession())) {
            this.updateTitle(propertiesOpened.getName());
        }
    }

    private void updateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, this.title));
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

