/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.messageconsole.events.PublishMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.kie.workbench.common.stunner.client.widgets.notification.AbstractNotification;
import org.kie.workbench.common.stunner.client.widgets.notification.NotificationsObserver;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class ProjectMessagesListener {
    private final Event<PublishMessagesEvent> publishMessagesEvent;
    private final NotificationsObserver notificationsObserver;
    private final AbstractClientSessionManager clientSessionManager;

    protected ProjectMessagesListener() {
        this(null, null, null);
    }

    @Inject
    public ProjectMessagesListener(NotificationsObserver notificationsObserver, Event<PublishMessagesEvent> publishMessagesEvent, AbstractClientSessionManager clientSessionManager) {
        this.publishMessagesEvent = publishMessagesEvent;
        this.notificationsObserver = notificationsObserver;
        this.clientSessionManager = clientSessionManager;
    }

    public void enable() {
        this.notificationsObserver.onCommandExecutionFailed(parameter -> this.fireNotification((AbstractNotification)parameter));
        this.notificationsObserver.onValidationFailed(parameter -> this.fireNotification((AbstractNotification)parameter));
    }

    void fireNotification(AbstractNotification notification) {
        ClientSession session = this.clientSessionManager.getCurrentSession();
        Path path = session.getCanvasHandler().getDiagram().getMetadata().getPath();
        SystemMessage systemMessage = new SystemMessage();
        ArrayList<SystemMessage> messagesList = new ArrayList<SystemMessage>();
        switch (notification.getType()) {
            case ERROR: {
                systemMessage.setLevel(Level.ERROR);
                break;
            }
            case WARNING: {
                systemMessage.setLevel(Level.WARNING);
                break;
            }
            case INFO: {
                systemMessage.setLevel(Level.INFO);
            }
        }
        systemMessage.setText(notification.getMessage());
        systemMessage.setPath(path);
        messagesList.add(systemMessage);
        PublishMessagesEvent messages = new PublishMessagesEvent();
        messages.setMessagesToPublish(messagesList);
        this.publishMessagesEvent.fire((Object)messages);
    }
}

