/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.factory;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.shared.core.types.ColorName;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.AbstractCompositeShape;
import org.kie.workbench.common.stunner.core.client.shape.AbstractShape;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.client.shape.MutableShape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.AbstractBindableShapeGlyphBuilder;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeGlyph;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeGlyphBuilder;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.GlyphDef;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.shapes.client.CircleShape;
import org.kie.workbench.common.stunner.shapes.client.ConnectorShape;
import org.kie.workbench.common.stunner.shapes.client.DynamicIconShape;
import org.kie.workbench.common.stunner.shapes.client.PolygonShape;
import org.kie.workbench.common.stunner.shapes.client.RectangleShape;
import org.kie.workbench.common.stunner.shapes.client.RingShape;
import org.kie.workbench.common.stunner.shapes.client.StaticIconShape;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.CircleView;
import org.kie.workbench.common.stunner.shapes.client.view.ConnectorView;
import org.kie.workbench.common.stunner.shapes.client.view.PolygonView;
import org.kie.workbench.common.stunner.shapes.client.view.RectangleView;
import org.kie.workbench.common.stunner.shapes.client.view.RingView;
import org.kie.workbench.common.stunner.shapes.client.view.ShapeViewFactory;
import org.kie.workbench.common.stunner.shapes.client.view.glyph.ConnectorGlyph;
import org.kie.workbench.common.stunner.shapes.client.view.icon.dynamics.DynamicIconShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.icon.statics.StaticIconShapeView;
import org.kie.workbench.common.stunner.shapes.def.CircleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.ConnectorShapeDef;
import org.kie.workbench.common.stunner.shapes.def.HasChildShapeDefs;
import org.kie.workbench.common.stunner.shapes.def.PolygonShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RectangleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RingShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.IconShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.Icons;
import org.kie.workbench.common.stunner.shapes.factory.BasicShapesFactory;

@ApplicationScoped
public class BasicShapesFactoryImpl
extends AbstractShapeDefFactory<Object, ShapeView, MutableShape<Object, ShapeView>, ShapeDef<Object>>
implements BasicShapesFactory<Object, AbstractCanvasHandler> {
    protected static final double DEFAULT_SIZE = 50.0;
    protected ShapeViewFactory shapeViewFactory;
    protected DefinitionManager definitionManager;
    protected ShapeGlyphBuilder<Group> glyphBuilder;

    protected BasicShapesFactoryImpl() {
    }

    @Inject
    public BasicShapesFactoryImpl(FactoryManager factoryManager, ShapeViewFactory shapeViewFactory, DefinitionManager definitionManager, ShapeGlyphBuilder<Group> glyphBuilder) {
        super(factoryManager);
        this.shapeViewFactory = shapeViewFactory;
        this.definitionManager = definitionManager;
        this.glyphBuilder = glyphBuilder;
    }

    public MutableShape<Object, ShapeView> build(Object definition, AbstractCanvasHandler context) {
        String id = this.definitionManager.adapters().forDefinition().getId(definition);
        ShapeDef proxy = this.getShapeDef(id);
        return this.build(definition, (ShapeDef<Object>)proxy, context);
    }

    protected MutableShape<Object, ShapeView> build(Object definition, ShapeDef<Object> proxy, AbstractCanvasHandler context) {
        HasChildShapeDefs hasChildren;
        Map childShapeDefs;
        org.kie.workbench.common.stunner.shapes.def.icon.statics.IconShapeDef iconProxy;
        PolygonShapeDef polygonProxy;
        BasicShapeView view;
        double radius;
        Object shape = null;
        if (this.isCircle(proxy)) {
            CircleShapeDef circleProxy = (CircleShapeDef)proxy;
            radius = circleProxy.getRadius(definition);
            view = this.shapeViewFactory.circle(radius);
            shape = new CircleShape((CircleView)view, circleProxy);
        }
        if (this.isRing(proxy)) {
            RingShapeDef ringProxy = (RingShapeDef)proxy;
            double oRadius = ringProxy.getOuterRadius(definition);
            view = this.shapeViewFactory.ring(oRadius);
            shape = new RingShape((RingView)view, ringProxy);
        }
        if (this.isRectangle(proxy)) {
            RectangleShapeDef rectangleProxy = (RectangleShapeDef)proxy;
            double width = rectangleProxy.getWidth(definition);
            double height = rectangleProxy.getHeight(definition);
            RectangleView view2 = this.shapeViewFactory.rectangle(width, height);
            shape = new RectangleShape(view2, rectangleProxy);
        }
        if (this.isPolygon(proxy)) {
            polygonProxy = (PolygonShapeDef)proxy;
            radius = polygonProxy.getRadius(definition);
            String fillColor = polygonProxy.getBackgroundColor(definition);
            PolygonView view3 = this.shapeViewFactory.polygon(radius, fillColor);
            shape = new PolygonShape(view3, polygonProxy);
        }
        if (this.isConnector(proxy)) {
            polygonProxy = (ConnectorShapeDef)proxy;
            ConnectorView view4 = this.shapeViewFactory.connector(0.0, 0.0, 100.0, 100.0);
            shape = new ConnectorShape(view4, polygonProxy);
        }
        if (this.isStaticIcon(proxy)) {
            iconProxy = (org.kie.workbench.common.stunner.shapes.def.icon.statics.IconShapeDef)proxy;
            org.kie.workbench.common.stunner.shapes.def.icon.statics.Icons icon = iconProxy.getIcon(definition);
            StaticIconShapeView view5 = this.shapeViewFactory.staticIcon(icon);
            shape = new StaticIconShape(view5, iconProxy);
        }
        if (this.isDynamicIcon(proxy)) {
            iconProxy = (IconShapeDef)proxy;
            Icons icon = DynamicIconShape.getIcon(definition, iconProxy);
            double width = iconProxy.getWidth(definition);
            double height = iconProxy.getHeight(definition);
            DynamicIconShapeView view6 = this.shapeViewFactory.dynamicIcon(icon, width, height);
            shape = new DynamicIconShape(view6, iconProxy);
        }
        if (null != shape && proxy instanceof HasChildShapeDefs && null != (childShapeDefs = (hasChildren = (HasChildShapeDefs)proxy).getChildShapeDefs()) && !childShapeDefs.isEmpty()) {
            for (Map.Entry entry : childShapeDefs.entrySet()) {
                ShapeDef child = (ShapeDef)entry.getKey();
                HasChildren.Layout layout = (HasChildren.Layout)entry.getValue();
                MutableShape<Object, ShapeView> childShape = this.build(definition, (ShapeDef<Object>)child, context);
                if (!(shape instanceof AbstractCompositeShape)) continue;
                ((AbstractCompositeShape)shape).addChild((AbstractShape)childShape, layout);
            }
        }
        if (null != shape) {
            return shape;
        }
        String id = this.definitionManager.adapters().forDefinition().getId(definition);
        throw new RuntimeException("This factory supports [" + id + "] but cannot built a shape for it.");
    }

    private boolean isCircle(ShapeDef<Object> proxy) {
        return proxy instanceof CircleShapeDef;
    }

    private boolean isRing(ShapeDef<Object> proxy) {
        return proxy instanceof RingShapeDef;
    }

    private boolean isRectangle(ShapeDef<Object> proxy) {
        return proxy instanceof RectangleShapeDef;
    }

    private boolean isPolygon(ShapeDef<Object> proxy) {
        return proxy instanceof PolygonShapeDef;
    }

    private boolean isConnector(ShapeDef<Object> proxy) {
        return proxy instanceof ConnectorShapeDef;
    }

    private boolean isDynamicIcon(ShapeDef<Object> proxy) {
        return proxy instanceof IconShapeDef;
    }

    private boolean isStaticIcon(ShapeDef<Object> proxy) {
        return proxy instanceof org.kie.workbench.common.stunner.shapes.def.icon.statics.IconShapeDef;
    }

    protected ShapeGlyph glyph(Class<?> clazz, double width, double height) {
        String id = this.getDefinitionId(clazz);
        ShapeDef proxy = this.getShapeDef(id);
        if (null != proxy && this.isConnector((ShapeDef<Object>)proxy)) {
            return new ConnectorGlyph(width, height, ColorName.BLACK.getColorString());
        }
        if (null != proxy) {
            if (this.glyphBuilder instanceof AbstractBindableShapeGlyphBuilder) {
                AbstractBindableShapeGlyphBuilder bindableShapeGlyphBuilder = (AbstractBindableShapeGlyphBuilder)this.glyphBuilder;
                bindableShapeGlyphBuilder.glyphProxy((GlyphDef)proxy, clazz);
            } else {
                this.glyphBuilder.glyphProxy((GlyphDef)proxy, id);
            }
        } else {
            this.glyphBuilder.definition(id);
        }
        return this.glyphBuilder.factory((ShapeFactory)this).height(height).width(width).build();
    }
}

