/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.IControlHandleList;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShapeControlHandleList;
import com.ait.lienzo.client.core.shape.wires.event.AbstractWiresDragEvent;
import com.ait.lienzo.client.core.shape.wires.event.AbstractWiresResizeEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeEndEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeEndHandler;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStartEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStartHandler;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepHandler;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.LinearGradient;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.AbstractShapeView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoShapeUtils;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.shapes.client.util.BasicShapesUtils;

public abstract class BasicShapeView<T>
extends AbstractShapeView<T>
implements HasTitle<T>,
HasControlPoints<T>,
HasEventHandlers<T, Shape<?>>,
HasFillGradient<T>,
HasChildren<BasicShapeView<T>> {
    private static final ViewEventType[] SUPPORTED_EVENT_TYPES = new ViewEventType[]{ViewEventType.MOUSE_CLICK, ViewEventType.MOUSE_DBL_CLICK, ViewEventType.DRAG, ViewEventType.RESIZE, ViewEventType.TOUCH, ViewEventType.GESTURE};
    private ViewEventHandlerManager eventHandlerManager;
    private final List<BasicShapeView<T>> children = new ArrayList<BasicShapeView<T>>();
    private Text text;
    private LayoutContainer.Layout textPosition = LayoutContainer.Layout.BOTTOM;
    private HasFillGradient.Type fillGradientType = null;
    private String fillGradientStartColor = null;
    private String fillGradientEndColor = null;

    public BasicShapeView(MultiPath path) {
        super(path);
        this.initialize();
    }

    private void initialize() {
        this.createEventHandlerManager((Node<?>)this.getGroup());
        this.postInitialize();
        this.refresh();
    }

    protected void postInitialize() {
    }

    private void createEventHandlerManager(Node<?> node) {
        if (null != node) {
            this.eventHandlerManager = new ViewEventHandlerManager(node, SUPPORTED_EVENT_TYPES);
        }
    }

    public void addChild(BasicShapeView<T> child, HasChildren.Layout layout) {
        this.children.add(child);
        super.addChild((IPrimitive)child.getContainer(), BasicShapesUtils.getWiresLayout(layout));
    }

    public void removeChild(BasicShapeView<T> child) {
        this.children.remove(child);
        super.removeChild((IPrimitive)child.getContainer());
    }

    public Iterable<BasicShapeView<T>> getChildren() {
        return this.children;
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public Shape<?> getAttachableShape() {
        return this.getShape();
    }

    public T setTitle(String title) {
        if (null == this.text) {
            this.text = this.buildText(title);
            this.addChild((IPrimitive)this.text, this.getTextPosition());
        } else {
            this.text.setText(title);
        }
        this.text.moveToTop();
        return (T)((Object)this);
    }

    public T setTitlePosition(HasTitle.Position position) {
        if (HasTitle.Position.BOTTOM.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.BOTTOM;
        } else if (HasTitle.Position.TOP.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.TOP;
        } else if (HasTitle.Position.LEFT.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.LEFT;
        } else if (HasTitle.Position.RIGHT.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.RIGHT;
        } else if (HasTitle.Position.CENTER.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.CENTER;
        }
        return (T)((Object)this);
    }

    public T setTitleStrokeColor(String color) {
        this.text.setStrokeColor(color);
        return (T)((Object)this);
    }

    public T setTitleFontFamily(String fontFamily) {
        this.text.setFontFamily(fontFamily);
        return (T)((Object)this);
    }

    public T setTitleFontSize(double fontSize) {
        this.text.setFontSize(fontSize);
        return (T)((Object)this);
    }

    public T setTitleAlpha(double alpha) {
        this.text.setAlpha(alpha);
        return (T)((Object)this);
    }

    public T setTitleStrokeWidth(double strokeWidth) {
        this.text.setStrokeWidth(strokeWidth);
        return (T)((Object)this);
    }

    public T moveTitleToTop() {
        this.text.moveToTop();
        return (T)((Object)this);
    }

    public T refreshTitle() {
        if (null != this.text) {
            this.text.moveToTop();
        }
        return (T)((Object)this);
    }

    private Text buildText(String _text) {
        Text text = (Text)((Text)new Text(_text).setFontSize(14.0).setFillColor((IColor)ColorName.BLACK)).setStrokeWidth(1.0);
        return (Text)((Text)((Text)text.moveToTop()).setDraggable(false)).setAlpha(0.0);
    }

    public Text getText() {
        return this.text;
    }

    private LayoutContainer.Layout getTextPosition() {
        return this.textPosition;
    }

    public T setFillGradient(HasFillGradient.Type type, String startColor, String endColor) {
        this.fillGradientType = type;
        this.fillGradientStartColor = startColor;
        this.fillGradientEndColor = endColor;
        if (null != this.getShape()) {
            BoundingBox bb = this.getShape().getBoundingBox();
            double width = bb.getWidth();
            double height = bb.getHeight();
            this.updateFillGradient(width, height);
        }
        return (T)((Object)this);
    }

    public T updateFillGradient(double width, double height) {
        if (this.fillGradientType != null && this.fillGradientStartColor != null && this.fillGradientEndColor != null) {
            LinearGradient gradient = LienzoShapeUtils.getLinearGradient((String)this.fillGradientStartColor, (String)this.fillGradientEndColor, (Double)width, (Double)height);
            this.getShape().setFillGradient(gradient);
        }
        return (T)((Object)this);
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        IControlHandleList ctrls = this.loadControls(this.translate(type));
        if (null != ctrls) {
            ctrls.show();
        }
        return (T)((Object)this);
    }

    private IControlHandle.ControlHandleType translate(HasControlPoints.ControlPointType type) {
        if (type.equals((Object)HasControlPoints.ControlPointType.RESIZE)) {
            return IControlHandle.ControlHandleStandardType.RESIZE;
        }
        return IControlHandle.ControlHandleStandardType.MAGNET;
    }

    public T hideControlPoints() {
        WiresShapeControlHandleList ctrls = this.getControls();
        if (null != ctrls) {
            ctrls.hide();
        }
        return (T)((Object)this);
    }

    protected void doDestroy() {
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
    }

    public void destroy() {
        super.destroy();
        this.text = null;
        this.textPosition = null;
        this.fillGradientEndColor = null;
        this.fillGradientStartColor = null;
        this.fillGradientType = null;
    }

    public T addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        if (this.supports(type)) {
            if (ViewEventType.DRAG.equals((Object)type)) {
                HandlerRegistration[] registrations = this.registerDragHandler((ViewHandler<DragEvent>)((DragHandler)eventHandler));
                this.eventHandlerManager.addHandlersRegistration(type, registrations);
            } else if (ViewEventType.RESIZE.equals((Object)type)) {
                HandlerRegistration[] registrations = this.registerResizeHandler((ViewHandler<ResizeEvent>)((ResizeHandler)eventHandler));
                this.eventHandlerManager.addHandlersRegistration(type, registrations);
            } else {
                this.eventHandlerManager.addHandler(type, eventHandler);
            }
        }
        return (T)((Object)this);
    }

    public T removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return (T)((Object)this);
    }

    public T enableHandlers() {
        this.eventHandlerManager.enable();
        return (T)((Object)this);
    }

    public T disableHandlers() {
        this.eventHandlerManager.disable();
        return (T)((Object)this);
    }

    private HandlerRegistration[] registerDragHandler(ViewHandler<DragEvent> eventHandler) {
        DragHandler dragHandler = (DragHandler)eventHandler;
        this.setDraggable(true);
        HandlerRegistration dragStartReg = this.addWiresDragStartHandler(wiresDragStartEvent -> {
            DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragStartEvent);
            dragHandler.start(e);
        });
        HandlerRegistration dragMoveReg = this.addWiresDragMoveHandler(wiresDragMoveEvent -> {
            DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragMoveEvent);
            dragHandler.handle((ViewEvent)e);
        });
        HandlerRegistration dragEndReg = this.addWiresDragEndHandler(wiresDragEndEvent -> {
            DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragEndEvent);
            dragHandler.end(e);
        });
        return new HandlerRegistration[]{dragStartReg, dragMoveReg, dragEndReg};
    }

    private HandlerRegistration[] registerResizeHandler(ViewHandler<ResizeEvent> eventHandler) {
        final ResizeHandler resizeHandler = (ResizeHandler)eventHandler;
        this.setResizable(true);
        HandlerRegistration r0 = this.addWiresResizeStartHandler(new WiresResizeStartHandler(){

            public void onShapeResizeStart(WiresResizeStartEvent wiresResizeStartEvent) {
                ResizeEvent event = BasicShapeView.this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeStartEvent);
                resizeHandler.start(event);
            }
        });
        HandlerRegistration r1 = this.addWiresResizeStepHandler(new WiresResizeStepHandler(){

            public void onShapeResizeStep(WiresResizeStepEvent wiresResizeStepEvent) {
                ResizeEvent event = BasicShapeView.this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeStepEvent);
                resizeHandler.handle((ViewEvent)event);
            }
        });
        HandlerRegistration r2 = this.addWiresResizeEndHandler(new WiresResizeEndHandler(){

            public void onShapeResizeEnd(WiresResizeEndEvent wiresResizeEndEvent) {
                ResizeEvent event = BasicShapeView.this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeEndEvent);
                resizeHandler.end(event);
            }
        });
        return new HandlerRegistration[]{r0, r1, r2};
    }

    private DragEvent buildDragEvent(AbstractWiresDragEvent sourceDragEvent) {
        double x = sourceDragEvent.getX();
        double y = sourceDragEvent.getY();
        double cx = sourceDragEvent.getNodeDragEvent().getX();
        double cy = sourceDragEvent.getNodeDragEvent().getY();
        int dx = sourceDragEvent.getNodeDragEvent().getDragContext().getDx();
        int dy = sourceDragEvent.getNodeDragEvent().getDragContext().getDy();
        return new DragEvent(x, y, cx, cy, dx, dy);
    }

    private ResizeEvent buildResizeEvent(AbstractWiresResizeEvent sourceResizeEvent) {
        double x = sourceResizeEvent.getX();
        double y = sourceResizeEvent.getY();
        double cx = sourceResizeEvent.getNodeDragEvent().getX();
        double cy = sourceResizeEvent.getNodeDragEvent().getY();
        double w = sourceResizeEvent.getWidth();
        double h = sourceResizeEvent.getHeight();
        return new ResizeEvent(x, y, cx, cy, w, h);
    }
}

