/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view;

import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.types.PathPartList;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.client.core.util.Geometry;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;

public class PolygonView
extends BasicShapeView<PolygonView>
implements HasRadius<PolygonView> {
    private static final int SIDES = 4;
    private static final double CORNER = 0.0;

    public PolygonView(double radius, String fillColor) {
        super(PolygonView.create(new MultiPath(), 4, radius, 0.0));
    }

    public PolygonView setRadius(double radius) {
        PolygonView.create((MultiPath)this.getPath().clear(), 4, radius, 0.0);
        return this;
    }

    private static MultiPath create(MultiPath result, int sides, double radius, double cornerRadius) {
        double ix = radius;
        double iy = radius;
        if (sides > 2 && radius > 0.0) {
            result.M(ix, iy - radius);
            if (cornerRadius <= 0.0) {
                for (int n = 1; n < sides; ++n) {
                    double theta = (double)(n * 2) * Math.PI / (double)sides;
                    result.L(ix + radius * Math.sin(theta), iy + -1.0 * radius * Math.cos(theta));
                }
                result.Z();
            } else {
                Point2DArray list = new Point2DArray(ix, iy - radius);
                for (int n = 1; n < sides; ++n) {
                    double theta = (double)(n * 2) * Math.PI / (double)sides;
                    list.push(ix + radius * Math.sin(theta), iy + -1.0 * radius * Math.cos(theta));
                }
                Geometry.drawArcJoinedLines((PathPartList)result.getPathPartList(), (Point2DArray)list.push(ix, iy - radius), (double)cornerRadius);
            }
        }
        return result;
    }
}

