/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client;

import org.kie.workbench.common.stunner.core.client.animation.Animation;
import org.kie.workbench.common.stunner.core.client.shape.AbstractConnector;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.shapes.client.view.BasicConnectorView;
import org.kie.workbench.common.stunner.shapes.client.view.animatiion.BasicConnectorAnimation;

public abstract class BasicConnector<W, V extends BasicConnectorView>
extends AbstractConnector<W, Edge<ViewConnector<W>, Node>, V> {
    private ShapeState state = ShapeState.NONE;
    private BasicConnectorAnimation animation = null;
    private Double _strokeWidth = null;
    private Double _strokeAlpha = null;
    private String _strokeColor = null;

    public BasicConnector(V view) {
        super(view);
    }

    protected abstract String getBackgroundColor(Edge<ViewConnector<W>, Node> var1);

    protected abstract Double getBackgroundAlpha(Edge<ViewConnector<W>, Node> var1);

    protected abstract String getBorderColor(Edge<ViewConnector<W>, Node> var1);

    protected abstract Double getBorderSize(Edge<ViewConnector<W>, Node> var1);

    protected abstract Double getBorderAlpha(Edge<ViewConnector<W>, Node> var1);

    public void applyProperties(Edge<ViewConnector<W>, Node> element, MutationContext mutationContext) {
        super.applyProperties(element, mutationContext);
        this._applyFillColor(element, mutationContext);
        this._applyFillApha(element, mutationContext);
        this._applyBorders(element, mutationContext);
        this._applyBorderApha(element, mutationContext);
    }

    public void beforeDraw() {
        super.beforeDraw();
        if (this.hasAnimation()) {
            this.getAnimation().setCallback(new Animation.AnimationCallback(){

                public void onStart() {
                }

                public void onFrame() {
                }

                public void onComplete() {
                    BasicConnector.this.animation = null;
                }
            });
            this.getAnimation().run();
        }
    }

    public void applyState(ShapeState shapeState) {
        if (!this.state.equals((Object)shapeState)) {
            this.state = shapeState;
            if (ShapeState.SELECTED.equals((Object)shapeState)) {
                this.applySelectedState();
            } else if (ShapeState.HIGHLIGHT.equals((Object)shapeState)) {
                this.applyHighlightState();
            } else if (ShapeState.INVALID.equals((Object)shapeState)) {
                this.applyInvalidState();
            } else {
                this.applyNoneState();
            }
        }
    }

    private void applySelectedState() {
        this.applyActiveState(ShapeState.SELECTED.getColor());
        ((BasicConnectorView)this.getShapeView()).getControl().showControlPoints();
    }

    private void applyInvalidState() {
        this.applyActiveState(ShapeState.INVALID.getColor());
    }

    private void applyHighlightState() {
        this.applyActiveState(ShapeState.HIGHLIGHT.getColor());
    }

    private void applyActiveState(String color) {
        if (null == this._strokeWidth) {
            this._strokeWidth = ((BasicConnectorView)this.getShapeView()).getLine().getStrokeWidth();
        }
        if (null == this._strokeColor) {
            this._strokeColor = ((BasicConnectorView)this.getShapeView()).getLine().getStrokeColor();
        }
        if (null == this._strokeAlpha) {
            this._strokeAlpha = ((BasicConnectorView)this.getShapeView()).getLine().getStrokeAlpha();
        }
        ((BasicConnectorView)this.getShapeView()).getLine().setStrokeWidth(5.0);
        ((BasicConnectorView)this.getShapeView()).getLine().setStrokeAlpha(1.0);
        ((BasicConnectorView)this.getShapeView()).getLine().setStrokeColor(color);
    }

    private void applyNoneState() {
        if (null != this._strokeWidth) {
            ((BasicConnectorView)this.getShapeView()).getLine().setStrokeWidth(this._strokeWidth.doubleValue());
            this._strokeWidth = null;
        }
        if (null != this._strokeColor) {
            ((BasicConnectorView)this.getShapeView()).getLine().setStrokeColor(this._strokeColor);
            this._strokeColor = null;
        }
        ((BasicConnectorView)this.getShapeView()).getLine().setStrokeAlpha(null != this._strokeAlpha ? this._strokeAlpha : 1.0);
        this._strokeAlpha = null;
    }

    protected BasicConnector<W, V> _applyFillColor(Edge<ViewConnector<W>, Node> element, MutationContext mutationContext) {
        String color = this.getBackgroundColor(element);
        if (color != null && color.trim().length() > 0) {
            if (this.isAnimationMutation(mutationContext)) {
                this.getAnimation().animateFillColor(color);
            } else {
                super._applyFillColor(color, mutationContext);
            }
        }
        return this;
    }

    protected BasicConnector<W, V> _applyFillApha(Edge<ViewConnector<W>, Node> element, MutationContext mutationContext) {
        Double alpha = this.getBackgroundAlpha(element);
        super._applyFillAlpha(alpha.doubleValue(), mutationContext);
        return this;
    }

    protected BasicConnector<W, V> _applyBorders(Edge<ViewConnector<W>, Node> element, MutationContext mutationContext) {
        String color = this.getBorderColor(element);
        Double width = this.getBorderSize(element);
        super._applyBorders(color, width, mutationContext);
        return this;
    }

    protected void _applyBorderColor(String color, MutationContext mutationContext) {
        boolean isAnimation = this.isAnimationMutation(mutationContext);
        if (isAnimation) {
            this.getAnimation().animateStrokeColor(color);
        } else {
            super._applyBorderColor(color, mutationContext);
        }
    }

    protected void _applyBorderWidth(double width, MutationContext mutationContext) {
        boolean isAnimation = this.isAnimationMutation(mutationContext);
        if (isAnimation) {
            this.getAnimation().animateStrokeWidth(width);
        } else {
            super._applyBorderWidth(width, mutationContext);
        }
    }

    protected BasicConnector<W, V> _applyBorderApha(Edge<ViewConnector<W>, Node> element, MutationContext mutationContext) {
        Double alpha = this.getBorderAlpha(element);
        super._applyBorderAlpha(alpha.doubleValue(), mutationContext);
        return this;
    }

    private boolean hasAnimation() {
        return null != this.animation;
    }

    private BasicConnectorAnimation getAnimation() {
        if (!this.hasAnimation()) {
            this.animation = new BasicConnectorAnimation();
            this.animation.forShape((Shape)this);
        }
        return this.animation;
    }
}

