/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client;

import org.kie.workbench.common.stunner.core.client.animation.Animation;
import org.kie.workbench.common.stunner.core.client.shape.AbstractCompositeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.animatiion.BasicShapeAnimation;
import org.kie.workbench.common.stunner.shapes.client.view.animatiion.BasicShapeDecoratorAnimation;

public abstract class BasicShape<W, V extends BasicShapeView>
extends AbstractCompositeShape<W, Node<View<W>, Edge>, V> {
    private ShapeState state = ShapeState.NONE;
    private BasicShapeAnimation animation = null;
    private Double _strokeWidth = null;
    private Double _strokeAlpha = null;
    private String _strokeColor = null;

    public BasicShape(V shapeView) {
        super(shapeView);
    }

    protected abstract String getBackgroundColor(Node<View<W>, Edge> var1);

    protected abstract Double getBackgroundAlpha(Node<View<W>, Edge> var1);

    protected abstract String getBorderColor(Node<View<W>, Edge> var1);

    protected abstract Double getBorderSize(Node<View<W>, Edge> var1);

    protected abstract Double getBorderAlpha(Node<View<W>, Edge> var1);

    protected W getDefinition(Node<View<W>, Edge> element) {
        return (W)((View)element.getContent()).getDefinition();
    }

    public void applyProperties(Node<View<W>, Edge> element, MutationContext mutationContext) {
        super.applyProperties(element, mutationContext);
        String color = this.getBackgroundColor(element);
        super.applyFillColor(color, mutationContext);
        Double alpha = this.getBackgroundAlpha(element);
        super.applyFillAlpha(alpha, mutationContext);
        this._strokeColor = this.getBorderColor(element);
        this._strokeWidth = this.getBorderSize(element);
        super.applyBorders(this._strokeColor, this._strokeWidth, mutationContext);
        this._strokeAlpha = this.getBorderAlpha(element);
        super.applyBorderAlpha(this._strokeAlpha, mutationContext);
    }

    public void beforeDraw() {
        super.beforeDraw();
        if (this.hasAnimation()) {
            this.getAnimation().setCallback(new Animation.AnimationCallback(){

                public void onStart() {
                }

                public void onFrame() {
                }

                public void onComplete() {
                    BasicShape.this.animation = null;
                }
            }).run();
        }
    }

    public void applyState(ShapeState shapeState) {
        if (!this.state.equals((Object)shapeState)) {
            this.state = shapeState;
            if (ShapeState.SELECTED.equals((Object)shapeState)) {
                this.applySelectedState();
            } else if (ShapeState.HIGHLIGHT.equals((Object)shapeState)) {
                this.applyHighlightState();
            } else if (ShapeState.INVALID.equals((Object)shapeState)) {
                this.applyInvalidState();
            } else {
                this.applyNoneState();
            }
        }
    }

    private void applySelectedState() {
        this.applyActiveState(ShapeState.SELECTED.getColor());
    }

    private void applyInvalidState() {
        this.applyActiveState(ShapeState.INVALID.getColor());
    }

    private void applyHighlightState() {
        this.applyActiveState(ShapeState.HIGHLIGHT.getColor());
    }

    private void applyActiveState(String color) {
        new BasicShapeDecoratorAnimation(color, 1.5, 1.0).forShape((Shape)this).run();
    }

    private void applyNoneState() {
        new BasicShapeDecoratorAnimation(this._strokeColor, null != this._strokeWidth ? this._strokeWidth : 1.0, null != this._strokeAlpha ? this._strokeAlpha : 1.0).forShape((Shape)this).run();
    }

    protected void applyFillColor(String color, MutationContext mutationContext) {
        boolean hasGradient = this.getShapeView() instanceof HasFillGradient;
        if (color != null && color.trim().length() > 0 && !hasGradient && this.isAnimationMutation(mutationContext)) {
            this.getAnimation().animateFillColor(color);
        } else {
            super.applyFillColor(color, mutationContext);
        }
    }

    protected void applyFontAlpha(HasTitle hasTitle, Double alpha, MutationContext mutationContext) {
        boolean isAnimation = this.isAnimationMutation(mutationContext);
        if (isAnimation) {
            this.getAnimation().animateFontAlpha(alpha);
        } else {
            super.applyFontAlpha(hasTitle, alpha, mutationContext);
        }
    }

    protected void _applyWidthAndHeight(Node<View<W>, Edge> element, Double width, Double height, MutationContext mutationContext) {
        this.applySize((HasSize)this.getShapeView(), width, height, mutationContext);
    }

    protected void applySize(HasSize hasSize, double width, double height, MutationContext mutationContext) {
        super.applySize(hasSize, width, height, mutationContext);
    }

    protected void _applyRadius(Node<View<W>, Edge> element, Double radius, MutationContext mutationContext) {
        if (null != radius) {
            this.applyRadius((HasRadius)this.getShapeView(), radius, mutationContext);
        }
    }

    protected void applyRadius(HasRadius hasRadius, double radius, MutationContext mutationContext) {
        if (radius > 0.0) {
            super.applyRadius(hasRadius, radius, mutationContext);
        }
    }

    private boolean hasAnimation() {
        return null != this.animation;
    }

    private BasicShapeAnimation getAnimation() {
        if (!this.hasAnimation()) {
            this.animation = new BasicShapeAnimation();
            this.animation.forShape((Shape)this);
        }
        return this.animation;
    }
}

