/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client;

import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.shapes.client.AbstractBasicDynamicShape;
import org.kie.workbench.common.stunner.shapes.client.view.icon.dynamics.DynamicIconShapeView;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.DynamicIconShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.IconShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.Icons;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.MinusIconShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.PlusIconShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.XORIconShapeDef;

public class DynamicIconShape<W>
extends AbstractBasicDynamicShape<W, DynamicIconShapeView, IconShapeDef<W>> {
    public DynamicIconShape(DynamicIconShapeView view, IconShapeDef<W> proxy) {
        super(view, proxy);
    }

    public static <T> Icons getIcon(IconShapeDef<T> proxy) {
        return DynamicIconShape.getIcon(null, proxy);
    }

    public static <T> Icons getIcon(T definition, IconShapeDef<T> proxy) {
        Icons icon = null;
        if (null != definition && proxy instanceof DynamicIconShapeDef) {
            DynamicIconShapeDef dynamicIconProxy = (DynamicIconShapeDef)proxy;
            icon = dynamicIconProxy.getIcon(definition);
        } else if (proxy instanceof MinusIconShapeDef) {
            icon = Icons.MINUS;
        } else if (proxy instanceof PlusIconShapeDef) {
            icon = Icons.PLUS;
        } else if (proxy instanceof XORIconShapeDef) {
            icon = Icons.XOR;
        }
        return icon;
    }

    @Override
    public void applyProperties(Node<View<W>, Edge> element, MutationContext mutationContext) {
        super.applyProperties(element, mutationContext);
        Double w = ((IconShapeDef)this.proxy).getWidth(this.getDefinition(element));
        Double h = ((IconShapeDef)this.proxy).getHeight(this.getDefinition(element));
        this._applyWidthAndHeight(element, w, h, mutationContext);
        Icons icon = DynamicIconShape.getIcon(this.getDefinition(element), (IconShapeDef)this.proxy);
        ((DynamicIconShapeView)this.getShapeView()).setIcon(icon);
    }

    public String toString() {
        return "DynamicIconShape{}";
    }
}

