/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.factory;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.AbstractCompositeShape;
import org.kie.workbench.common.stunner.core.client.shape.AbstractShape;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.client.shape.MutableShape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.GlyphBuilderFactory;
import org.kie.workbench.common.stunner.core.definition.shape.GlyphDef;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.shapes.client.CircleShape;
import org.kie.workbench.common.stunner.shapes.client.ConnectorShape;
import org.kie.workbench.common.stunner.shapes.client.DynamicIconShape;
import org.kie.workbench.common.stunner.shapes.client.PictureShape;
import org.kie.workbench.common.stunner.shapes.client.PolygonShape;
import org.kie.workbench.common.stunner.shapes.client.RectangleShape;
import org.kie.workbench.common.stunner.shapes.client.RingShape;
import org.kie.workbench.common.stunner.shapes.client.StaticIconShape;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.CircleView;
import org.kie.workbench.common.stunner.shapes.client.view.ConnectorView;
import org.kie.workbench.common.stunner.shapes.client.view.PictureShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.PolygonView;
import org.kie.workbench.common.stunner.shapes.client.view.RectangleView;
import org.kie.workbench.common.stunner.shapes.client.view.RingView;
import org.kie.workbench.common.stunner.shapes.client.view.ShapeViewFactory;
import org.kie.workbench.common.stunner.shapes.client.view.icon.dynamics.DynamicIconShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.icon.statics.StaticIconShapeView;
import org.kie.workbench.common.stunner.shapes.def.CircleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.ConnectorShapeDef;
import org.kie.workbench.common.stunner.shapes.def.HasChildShapeDefs;
import org.kie.workbench.common.stunner.shapes.def.PolygonShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RectangleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RingShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.IconShapeDef;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.Icons;
import org.kie.workbench.common.stunner.shapes.def.picture.PictureShapeDef;
import org.kie.workbench.common.stunner.shapes.factory.BasicShapesFactory;

@ApplicationScoped
public class BasicShapesFactoryImpl
extends AbstractShapeDefFactory<Object, ShapeView, MutableShape<Object, ShapeView>, ShapeDef<Object>>
implements BasicShapesFactory<Object, AbstractCanvasHandler> {
    private final ShapeViewFactory shapeViewFactory;
    private final GlyphBuilderFactory glyphBuilderFactory;

    protected BasicShapesFactoryImpl() {
        this(null, null, null, null);
    }

    @Inject
    public BasicShapesFactoryImpl(FactoryManager factoryManager, ShapeViewFactory shapeViewFactory, DefinitionManager definitionManager, GlyphBuilderFactory glyphBuilderFactory) {
        super(definitionManager, factoryManager);
        this.shapeViewFactory = shapeViewFactory;
        this.glyphBuilderFactory = glyphBuilderFactory;
    }

    public MutableShape<Object, ShapeView> build(Object definition, AbstractCanvasHandler context) {
        String id = this.definitionManager.adapters().forDefinition().getId(definition);
        ShapeDef proxy = this.getShapeDef(id);
        return this.build(definition, (ShapeDef<Object>)proxy, context);
    }

    protected MutableShape<Object, ShapeView> build(Object definition, ShapeDef<Object> proxy, AbstractCanvasHandler context) {
        HasChildShapeDefs hasChildren;
        Map childShapeDefs;
        BasicShapeView view;
        org.kie.workbench.common.stunner.shapes.def.icon.statics.IconShapeDef iconProxy;
        PolygonShapeDef polygonProxy;
        BasicShapeView view2;
        double radius;
        boolean found = false;
        Object shape = null;
        if (this.isCircle(proxy)) {
            CircleShapeDef circleProxy = (CircleShapeDef)proxy;
            radius = circleProxy.getRadius(definition);
            view2 = this.shapeViewFactory.circle(radius);
            shape = new CircleShape((CircleView)view2, circleProxy);
            found = true;
        }
        if (this.isRing(proxy)) {
            RingShapeDef ringProxy = (RingShapeDef)proxy;
            double oRadius = ringProxy.getOuterRadius(definition);
            view2 = this.shapeViewFactory.ring(oRadius);
            shape = new RingShape((RingView)view2, ringProxy);
            found = true;
        }
        if (this.isRectangle(proxy)) {
            RectangleShapeDef rectangleProxy = (RectangleShapeDef)proxy;
            double width = rectangleProxy.getWidth(definition);
            double height = rectangleProxy.getHeight(definition);
            double cr = rectangleProxy.getCornerRadius(definition);
            RectangleView view3 = this.shapeViewFactory.rectangle(width, height, cr);
            shape = new RectangleShape(view3, rectangleProxy);
            found = true;
        }
        if (this.isPolygon(proxy)) {
            polygonProxy = (PolygonShapeDef)proxy;
            radius = polygonProxy.getRadius(definition);
            String fillColor = polygonProxy.getBackgroundColor(definition);
            PolygonView view4 = this.shapeViewFactory.polygon(radius, fillColor);
            shape = new PolygonShape(view4, polygonProxy);
            found = true;
        }
        if (this.isConnector(proxy)) {
            polygonProxy = (ConnectorShapeDef)proxy;
            ConnectorView view5 = this.shapeViewFactory.connector(0.0, 0.0, 100.0, 100.0);
            shape = new ConnectorShape(view5, polygonProxy);
            found = true;
        }
        if (this.isStaticIcon(proxy)) {
            iconProxy = (org.kie.workbench.common.stunner.shapes.def.icon.statics.IconShapeDef)proxy;
            org.kie.workbench.common.stunner.shapes.def.icon.statics.Icons icon = iconProxy.getIcon(definition);
            StaticIconShapeView view6 = this.shapeViewFactory.staticIcon(icon);
            shape = new StaticIconShape(view6, iconProxy);
            found = true;
        }
        if (this.isPicture(proxy)) {
            PictureShapeDef pictureProxy = (PictureShapeDef)proxy;
            Object pictureSource = pictureProxy.getPictureSource(definition);
            if (null != pictureSource) {
                double width = pictureProxy.getWidth(definition);
                double height = pictureProxy.getHeight(definition);
                view = this.shapeViewFactory.picture(pictureSource, width, height);
                shape = new PictureShape((PictureShapeView)view, pictureProxy);
            }
            found = true;
        }
        if (this.isDynamicIcon(proxy)) {
            iconProxy = (IconShapeDef)proxy;
            Icons icon = DynamicIconShape.getIcon(definition, iconProxy);
            double width = iconProxy.getWidth(definition);
            double height = iconProxy.getHeight(definition);
            view = this.shapeViewFactory.dynamicIcon(icon, width, height);
            shape = new DynamicIconShape((DynamicIconShapeView)view, iconProxy);
            found = true;
        }
        if (null != shape && shape instanceof AbstractCompositeShape && proxy instanceof HasChildShapeDefs && null != (childShapeDefs = (hasChildren = (HasChildShapeDefs)proxy).getChildShapeDefs()) && !childShapeDefs.isEmpty()) {
            for (Map.Entry entry : childShapeDefs.entrySet()) {
                ShapeDef child = (ShapeDef)entry.getKey();
                HasChildren.Layout layout = (HasChildren.Layout)entry.getValue();
                MutableShape<Object, ShapeView> childShape = this.build(definition, (ShapeDef<Object>)child, context);
                if (null == childShape) continue;
                ((AbstractCompositeShape)shape).addChild((AbstractShape)childShape, layout);
            }
        }
        if (!found) {
            String id = this.definitionManager.adapters().forDefinition().getId(definition);
            throw new RuntimeException("This factory supports [" + id + "] but cannot built a shape for it.");
        }
        return shape;
    }

    private boolean isCircle(ShapeDef<Object> proxy) {
        return proxy instanceof CircleShapeDef;
    }

    private boolean isRing(ShapeDef<Object> proxy) {
        return proxy instanceof RingShapeDef;
    }

    private boolean isRectangle(ShapeDef<Object> proxy) {
        return proxy instanceof RectangleShapeDef;
    }

    private boolean isPolygon(ShapeDef<Object> proxy) {
        return proxy instanceof PolygonShapeDef;
    }

    private boolean isConnector(ShapeDef<Object> proxy) {
        return proxy instanceof ConnectorShapeDef;
    }

    private boolean isDynamicIcon(ShapeDef<Object> proxy) {
        return proxy instanceof IconShapeDef;
    }

    private boolean isStaticIcon(ShapeDef<Object> proxy) {
        return proxy instanceof org.kie.workbench.common.stunner.shapes.def.icon.statics.IconShapeDef;
    }

    private boolean isPicture(ShapeDef<Object> proxy) {
        return proxy instanceof PictureShapeDef;
    }

    protected Glyph glyph(Class<?> clazz, double width, double height) {
        ShapeDef shapeDef = this.getShapeDef(clazz);
        GlyphDef glyphDef = shapeDef.getGlyphDef();
        return this.glyphBuilderFactory.getBuilder(glyphDef).definitionType(clazz).glyphDef(glyphDef).factory((ShapeFactory)this).height(height).width(width).build();
    }
}

