/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.factory;

import com.google.gwt.safehtml.shared.SafeUri;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.shapes.def.picture.PictureProvider;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class PictureProvidersManager {
    private static Logger LOGGER = Logger.getLogger(PictureProvidersManager.class.getName());
    private final ManagedInstance<PictureProvider> pictureProviderManagedInstances;
    private final List<PictureProvider> providers = new LinkedList<PictureProvider>();

    @Inject
    public PictureProvidersManager(ManagedInstance<PictureProvider> pictureProviderManagedInstances) {
        this.pictureProviderManagedInstances = pictureProviderManagedInstances;
    }

    @PostConstruct
    public void init() {
        this.pictureProviderManagedInstances.forEach(this.providers::add);
    }

    public SafeUri getUri(Object source) {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        Class<?> type = source.getClass();
        PictureProvider provider = this.providers.stream().filter(pictureProvider -> pictureProvider.getSourceType().equals(type)).findFirst().orElse(null);
        if (null != provider) {
            return provider.getThumbnailUri(source);
        }
        LOGGER.log(Level.SEVERE, "Picture provider not found for [" + source + "]");
        return null;
    }
}

