/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view;

import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.MultiPathDecorator;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.AbstractConnectorView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public abstract class BasicConnectorView<T>
extends AbstractConnectorView<T>
implements HasTitle<T>,
HasEventHandlers<T, Shape<?>> {
    protected ViewEventHandlerManager eventHandlerManager;
    protected Text text;
    protected LayoutContainer.Layout textPosition;
    protected double textRotationDegrees;
    private Double strokeWidth;
    private String color;

    public BasicConnectorView(ViewEventType[] supportedEventTypes, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(line, headDecorator, tailDecorator);
        this.init(supportedEventTypes);
    }

    public BasicConnectorView(ViewEventType[] supportedEventTypes, WiresMagnet headMagnet, WiresMagnet tailMagnet, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(headMagnet, tailMagnet, line, headDecorator, tailDecorator);
        this.init(supportedEventTypes);
    }

    protected void init(ViewEventType[] supportedEventTypes) {
        this.textPosition = LayoutContainer.Layout.CENTER;
        this.textRotationDegrees = 0.0;
        this.eventHandlerManager = new ViewEventHandlerManager((Node)this.getLine(), supportedEventTypes);
        this.enableShowControlsOnMouseEnter();
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public Shape<?> getAttachableShape() {
        return this.getLine();
    }

    public T addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.addHandler(type, eventHandler);
        return (T)((Object)this);
    }

    public T removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return (T)((Object)this);
    }

    public T disableHandlers() {
        this.eventHandlerManager.disable();
        return (T)((Object)this);
    }

    public T enableHandlers() {
        this.eventHandlerManager.enable();
        return (T)((Object)this);
    }

    public T setTitle(String title) {
        if (null != this.text) {
            this.text.removeFromParent();
        }
        if (null != title) {
            // empty if block
        }
        return (T)((Object)this);
    }

    public T setTitlePosition(HasTitle.Position position) {
        if (HasTitle.Position.BOTTOM.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.BOTTOM;
        } else if (HasTitle.Position.TOP.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.TOP;
        } else if (HasTitle.Position.LEFT.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.LEFT;
        } else if (HasTitle.Position.RIGHT.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.RIGHT;
        } else if (HasTitle.Position.CENTER.equals((Object)position)) {
            this.textPosition = LayoutContainer.Layout.CENTER;
        }
        return (T)((Object)this);
    }

    public T setTitleRotation(double degrees) {
        this.textRotationDegrees = degrees;
        return (T)((Object)this);
    }

    public T setTitleStrokeColor(String color) {
        this.text.setStrokeColor(color);
        return (T)((Object)this);
    }

    public T setTitleFontFamily(String fontFamily) {
        this.text.setFontFamily(fontFamily);
        return (T)((Object)this);
    }

    public T setTitleFontSize(double fontSize) {
        this.text.setFontSize(fontSize);
        return (T)((Object)this);
    }

    public T setTitleStrokeWidth(double strokeWidth) {
        this.text.setStrokeWidth(strokeWidth);
        return (T)((Object)this);
    }

    public T moveTitleToTop() {
        this.text.moveToTop();
        return (T)((Object)this);
    }

    public T setTitleAlpha(double alpha) {
        this.text.setAlpha(alpha);
        return (T)((Object)this);
    }

    public T refreshTitle() {
        return (T)((Object)this);
    }

    protected void doDestroy() {
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
    }

    public void destroy() {
        super.destroy();
        this.text = null;
        this.textPosition = null;
        this.strokeWidth = null;
        this.color = null;
    }
}

