/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view.animatiion;

import com.ait.lienzo.client.core.animation.AnimationProperties;
import com.ait.lienzo.client.core.animation.AnimationProperty;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.Text;
import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.shapes.client.BasicShape;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.animatiion.AbstractBasicAnimation;

public class BasicShapeAnimation
extends AbstractBasicAnimation<BasicShape> {
    private final List<AnimationProperty> shapeAnimationProperties = new LinkedList<AnimationProperty>();
    private final List<AnimationProperty> decoratorAnimationProperties = new LinkedList<AnimationProperty>();
    private final List<AnimationProperty> textAnimationProperties = new LinkedList<AnimationProperty>();

    public void run() {
        AnimationTweener tweener = AnimationTweener.LINEAR;
        BasicShapeView<?> view = this.getView();
        Text text = view.getText();
        long duration = this.getDuration();
        Shape shape = view.getShape();
        AnimationProperties _shapeAnimationProperties = this.translate(this.shapeAnimationProperties);
        shape.animate(tweener, _shapeAnimationProperties, (double)duration, (IAnimationCallback)this.getAnimationCallback());
        this.shapeAnimationProperties.clear();
        MultiPath decorator = view.getPath();
        if (null != decorator) {
            AnimationProperties _decoratorAnimationProperties = this.translate(this.decoratorAnimationProperties);
            decorator.animate(tweener, _decoratorAnimationProperties, (double)duration);
            this.decoratorAnimationProperties.clear();
        }
        if (null != text) {
            AnimationProperties _textAnimationProperties = this.translate(this.textAnimationProperties);
            text.animate(tweener, _textAnimationProperties, (double)duration);
            this.textAnimationProperties.clear();
        }
    }

    private AnimationProperties translate(List<AnimationProperty> ps) {
        AnimationProperties _ps = new AnimationProperties();
        for (AnimationProperty p : ps) {
            _ps.push(p);
        }
        return _ps;
    }

    private BasicShapeView<?> getView() {
        return (BasicShapeView)((BasicShape)this.getSource()).getShapeView();
    }

    public void clear() {
        this.shapeAnimationProperties.clear();
        this.decoratorAnimationProperties.clear();
        this.textAnimationProperties.clear();
    }

    public void animatePosition(Double x, Double y) {
        if (null != x) {
            this.shapeAnimationProperties.add(AnimationProperty.Properties.X((double)x));
        }
        if (null != y) {
            this.shapeAnimationProperties.add(AnimationProperty.Properties.Y((double)y));
        }
    }

    public void animateSize(Double w, Double h) {
        if (null != w && null != h) {
            ((HasSize)this.getView()).setSize(w.doubleValue(), h.doubleValue());
            this.shapeAnimationProperties.add(AnimationProperty.Properties.WIDTH((double)w));
            this.decoratorAnimationProperties.add(AnimationProperty.Properties.WIDTH((double)w));
            this.shapeAnimationProperties.add(AnimationProperty.Properties.HEIGHT((double)h));
            this.decoratorAnimationProperties.add(AnimationProperty.Properties.HEIGHT((double)h));
            this.getView().updateFillGradient(w, h);
        }
    }

    public void animateRadius(Double value) {
        if (null != value) {
            ((HasRadius)this.getView()).setRadius(value.doubleValue());
            this.shapeAnimationProperties.add(AnimationProperty.Properties.RADIUS((double)value));
            this.decoratorAnimationProperties.add(AnimationProperty.Properties.RADIUS((double)value));
            double size = value * 2.0;
            this.getView().updateFillGradient(size, size);
        }
    }

    public void animateFillColor(String value) {
        this.shapeAnimationProperties.add(AnimationProperty.Properties.FILL_COLOR((String)value));
    }

    public void animateStrokeColor(String value) {
        this.shapeAnimationProperties.add(AnimationProperty.Properties.STROKE_COLOR((String)value));
    }

    public void animateStrokeWidth(Double value) {
        this.shapeAnimationProperties.add(AnimationProperty.Properties.STROKE_WIDTH((double)value));
    }

    public void animateFontSize(Double value) {
        this.textAnimationProperties.add(AnimationProperty.Properties.FONT_SIZE((double)value));
    }

    public void animateFontAlpha(Double value) {
        this.textAnimationProperties.add(AnimationProperty.Properties.ALPHA((double)value));
    }
}

