/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view.icon.dynamics;

import com.ait.lienzo.client.core.shape.MultiPath;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapesSupportedEvents;
import org.kie.workbench.common.stunner.shapes.client.view.icon.dynamics.DynamicIconsBuilder;
import org.kie.workbench.common.stunner.shapes.def.icon.dynamics.Icons;

public class DynamicIconShapeView<T extends DynamicIconShapeView>
extends BasicShapeView<T>
implements HasSize<T> {
    private static final String BLACK = "#000000";
    private static final double STROKE_WIDTH = 0.0;
    private Icons icon;
    private double width;
    private double height;

    public DynamicIconShapeView(Icons icon, double width, double height) {
        super(BasicShapesSupportedEvents.ALL_DESKTOP_EVENT_TYPES, DynamicIconShapeView.buildIcon(new MultiPath(), icon, width, height, BLACK, BLACK, 0.0));
        this.icon = icon;
        this.width = width;
        this.height = height;
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.icon = null;
        this.width = 0.0;
        this.height = 0.0;
    }

    public T setIcon(Icons icon) {
        this.icon = icon;
        this.updateIcon();
        return (T)((Object)this);
    }

    public T setSize(double width, double height) {
        this.width = width;
        this.height = height;
        this.updateIcon();
        return (T)((Object)this);
    }

    private void updateIcon() {
        DynamicIconShapeView.buildIcon(this.getPath(), this.icon, this.width, this.height, this.getFillColor(), this.getStrokeColor(), this.getStrokeWidth());
    }

    private static MultiPath buildIcon(MultiPath path, Icons icon, double w, double h, String fillColor, String strokeColor, double strokeWidth) {
        return (MultiPath)((MultiPath)((MultiPath)DynamicIconsBuilder.build(path, icon, w, h).setFillColor(fillColor)).setStrokeColor(strokeColor)).setStrokeWidth(strokeWidth);
    }
}

