/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view.icon.statics;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.types.BoundingBox;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.BasicShapesSupportedEvents;
import org.kie.workbench.common.stunner.shapes.client.view.icon.statics.StaticIconsBuilder;
import org.kie.workbench.common.stunner.shapes.def.icon.statics.Icons;

public class StaticIconShapeView<T extends StaticIconShapeView>
extends BasicShapeView<T> {
    private Icons icon;
    private double width;
    private double height;
    private Group iconGroup;

    public StaticIconShapeView(Icons icon) {
        super(BasicShapesSupportedEvents.DESKTOP_NO_RESIZE_EVENT_TYPES, (MultiPath)((MultiPath)new MultiPath().setStrokeWidth(0.0)).setStrokeAlpha(0.0));
        this.setIcon(icon);
    }

    public T setIcon(Icons icon) {
        this.icon = icon;
        this.buildIconView();
        return (T)((Object)this);
    }

    private void buildIconView() {
        this.getPath().clear();
        if (null != this.iconGroup) {
            this.removeChild((IPrimitive)this.iconGroup);
        }
        this.iconGroup = StaticIconsBuilder.build(this.icon);
        if (null != this.iconGroup) {
            BoundingBox bb = this.iconGroup.getBoundingBox();
            double w = bb.getWidth();
            double h = bb.getHeight();
            this.width = w;
            this.height = h;
            this.getPath().rect(0.0, 0.0, w, h);
            this.addChild((IPrimitive)this.iconGroup, LayoutContainer.Layout.CENTER);
        }
        this.refresh();
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        if (null != this.iconGroup) {
            this.iconGroup.removeFromParent();
            this.iconGroup = null;
        }
        this.icon = null;
    }
}

