/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.factory;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.WiresContainerShapeView;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.Glyph;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.GlyphBuilderFactory;
import org.kie.workbench.common.stunner.core.definition.shape.GlyphDef;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.shapes.client.CircleShape;
import org.kie.workbench.common.stunner.shapes.client.ConnectorShape;
import org.kie.workbench.common.stunner.shapes.client.PictureShape;
import org.kie.workbench.common.stunner.shapes.client.PolygonShape;
import org.kie.workbench.common.stunner.shapes.client.RectangleShape;
import org.kie.workbench.common.stunner.shapes.client.RingShape;
import org.kie.workbench.common.stunner.shapes.client.view.CircleView;
import org.kie.workbench.common.stunner.shapes.client.view.ConnectorView;
import org.kie.workbench.common.stunner.shapes.client.view.PictureShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.PolygonView;
import org.kie.workbench.common.stunner.shapes.client.view.RectangleView;
import org.kie.workbench.common.stunner.shapes.client.view.RingView;
import org.kie.workbench.common.stunner.shapes.client.view.ShapeViewFactory;
import org.kie.workbench.common.stunner.shapes.def.CircleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.ConnectorShapeDef;
import org.kie.workbench.common.stunner.shapes.def.HasChildShapeDefs;
import org.kie.workbench.common.stunner.shapes.def.PolygonShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RectangleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RingShapeDef;
import org.kie.workbench.common.stunner.shapes.def.picture.PictureShapeDef;
import org.kie.workbench.common.stunner.shapes.factory.BasicShapesFactory;

@ApplicationScoped
public class BasicShapesFactoryImpl
extends AbstractShapeDefFactory<Object, ShapeView, Shape<ShapeView>, ShapeDef<Object>>
implements BasicShapesFactory<Object, AbstractCanvasHandler> {
    private final ShapeViewFactory shapeViewFactory;
    private final GlyphBuilderFactory glyphBuilderFactory;

    protected BasicShapesFactoryImpl() {
        this(null, null, null, null);
    }

    @Inject
    public BasicShapesFactoryImpl(FactoryManager factoryManager, ShapeViewFactory shapeViewFactory, DefinitionManager definitionManager, GlyphBuilderFactory glyphBuilderFactory) {
        super(definitionManager, factoryManager);
        this.shapeViewFactory = shapeViewFactory;
        this.glyphBuilderFactory = glyphBuilderFactory;
    }

    public Shape<ShapeView> build(Object definition, AbstractCanvasHandler context) {
        String id = this.definitionManager.adapters().forDefinition().getId(definition);
        ShapeDef proxy = this.getShapeDef(id);
        return this.build(definition, (ShapeDef<Object>)proxy, context);
    }

    protected Shape<ShapeView> build(Object definition, ShapeDef<Object> proxy, AbstractCanvasHandler context) {
        HasChildShapeDefs hasChildren;
        Map childShapeDefs;
        PolygonShapeDef polygonProxy;
        WiresContainerShapeView view;
        double radius;
        boolean found = false;
        Object shape = null;
        if (this.isCircle(proxy)) {
            CircleShapeDef circleProxy = (CircleShapeDef)proxy;
            radius = circleProxy.getRadius(definition);
            view = this.shapeViewFactory.circle(radius);
            shape = new CircleShape(circleProxy, (CircleView)view);
            found = true;
        }
        if (this.isRing(proxy)) {
            RingShapeDef ringProxy = (RingShapeDef)proxy;
            double oRadius = ringProxy.getOuterRadius(definition);
            view = this.shapeViewFactory.ring(oRadius);
            shape = new RingShape(ringProxy, (RingView)view);
            found = true;
        }
        if (this.isRectangle(proxy)) {
            RectangleShapeDef rectangleProxy = (RectangleShapeDef)proxy;
            double width = rectangleProxy.getWidth(definition);
            double height = rectangleProxy.getHeight(definition);
            double cr = rectangleProxy.getCornerRadius(definition);
            RectangleView view2 = this.shapeViewFactory.rectangle(width, height, cr);
            shape = new RectangleShape(rectangleProxy, view2);
            found = true;
        }
        if (this.isPolygon(proxy)) {
            polygonProxy = (PolygonShapeDef)proxy;
            radius = polygonProxy.getRadius(definition);
            String fillColor = polygonProxy.getBackgroundColor(definition);
            PolygonView view3 = this.shapeViewFactory.polygon(radius, fillColor);
            shape = new PolygonShape(polygonProxy, view3);
            found = true;
        }
        if (this.isConnector(proxy)) {
            polygonProxy = (ConnectorShapeDef)proxy;
            ConnectorView view4 = this.shapeViewFactory.connector(0.0, 0.0, 100.0, 100.0);
            shape = new ConnectorShape(polygonProxy, view4);
            found = true;
        }
        if (this.isPicture(proxy)) {
            PictureShapeDef pictureProxy = (PictureShapeDef)proxy;
            Object pictureSource = pictureProxy.getPictureSource(definition);
            if (null != pictureSource) {
                double width = pictureProxy.getWidth(definition);
                double height = pictureProxy.getHeight(definition);
                PictureShapeView view5 = this.shapeViewFactory.picture(pictureSource, width, height);
                shape = new PictureShape(view5);
            }
            found = true;
        }
        if (null != shape && proxy instanceof HasChildShapeDefs && null != (childShapeDefs = (hasChildren = (HasChildShapeDefs)proxy).getChildShapeDefs()) && !childShapeDefs.isEmpty()) {
            for (Map.Entry entry : childShapeDefs.entrySet()) {
                ShapeDef child = (ShapeDef)entry.getKey();
                HasChildren.Layout layout = (HasChildren.Layout)entry.getValue();
                Shape<ShapeView> childShape = this.build(definition, (ShapeDef<Object>)child, context);
                if (null == childShape) continue;
                ((HasChildren)shape).addChild(childShape, layout);
            }
        }
        if (!found) {
            String id = this.definitionManager.adapters().forDefinition().getId(definition);
            throw new RuntimeException("This factory supports [" + id + "] but cannot built a shape for it.");
        }
        return shape;
    }

    private boolean isCircle(ShapeDef<Object> proxy) {
        return proxy instanceof CircleShapeDef;
    }

    private boolean isRing(ShapeDef<Object> proxy) {
        return proxy instanceof RingShapeDef;
    }

    private boolean isRectangle(ShapeDef<Object> proxy) {
        return proxy instanceof RectangleShapeDef;
    }

    private boolean isPolygon(ShapeDef<Object> proxy) {
        return proxy instanceof PolygonShapeDef;
    }

    private boolean isConnector(ShapeDef<Object> proxy) {
        return proxy instanceof ConnectorShapeDef;
    }

    private boolean isPicture(ShapeDef<Object> proxy) {
        return proxy instanceof PictureShapeDef;
    }

    protected Glyph glyph(Class<?> clazz, double width, double height) {
        ShapeDef shapeDef = this.getShapeDef(clazz);
        GlyphDef glyphDef = shapeDef.getGlyphDef();
        return this.glyphBuilderFactory.getBuilder(glyphDef).definitionType(clazz).glyphDef(glyphDef).factory((ShapeFactory)this).height(height).width(width).build();
    }
}

