/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Ring;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeEndEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeEndHandler;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStartEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStartHandler;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepEvent;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepHandler;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresContainerShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.event.HandlerRegistrationImpl;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ShapeViewSupportedEvents;

public class RingView
extends WiresContainerShapeView<RingView>
implements HasRadius<RingView> {
    private static final int INNER_RADIUS_FACTOR = 2;
    private Ring ring;
    private final HandlerRegistrationImpl registrations = new HandlerRegistrationImpl();

    public RingView(double radius) {
        super(ShapeViewSupportedEvents.DESKTOP_NO_RESIZE_EVENT_TYPES, RingView.initPath(new MultiPath(), radius));
        this.ring = new Ring(RingView.getInnerRadius(radius), RingView.getOuterRadius(radius));
        this.addChild((IPrimitive)this.ring, LayoutContainer.Layout.CENTER);
        super.setResizable(false);
    }

    public Shape<?> getShape() {
        return this.ring;
    }

    public RingView setRadius(double radius) {
        RingView.initPath((MultiPath)this.getPath().clear(), radius);
        this.updateFillGradient(radius * 2.0, radius * 2.0);
        double o = RingView.getOuterRadius(radius);
        double i = RingView.getInnerRadius(radius);
        this.ring.setOuterRadius(o);
        this.ring.setInnerRadius(i);
        this.refresh();
        return this;
    }

    public RingView setOuterRadius(double radius) {
        return this.setRadius(radius);
    }

    public RingView setInnerRadius(double inner) {
        return this.setOuterRadius(inner * 2.0);
    }

    protected void preDestroy() {
        super.preDestroy();
        this.registrations.removeHandler();
        this.ring.removeFromParent();
    }

    private void initResizeHandlers() {
        this.registrations.register(this.addWiresResizeStartHandler(new WiresResizeStartHandler(){

            public void onShapeResizeStart(WiresResizeStartEvent wiresResizeStartEvent) {
                RingView.this.resize(wiresResizeStartEvent.getWidth(), wiresResizeStartEvent.getHeight());
            }
        }));
        this.registrations.register(this.addWiresResizeStepHandler(new WiresResizeStepHandler(){

            public void onShapeResizeStep(WiresResizeStepEvent wiresResizeStepEvent) {
                RingView.this.resize(wiresResizeStepEvent.getWidth(), wiresResizeStepEvent.getHeight());
            }
        }));
        this.registrations.register(this.addWiresResizeEndHandler(new WiresResizeEndHandler(){

            public void onShapeResizeEnd(WiresResizeEndEvent wiresResizeEndEvent) {
                RingView.this.resize(wiresResizeEndEvent.getWidth(), wiresResizeEndEvent.getHeight());
            }
        }));
    }

    private void resize(double width, double height) {
        this.setRadius(width >= height ? height : width);
    }

    private static MultiPath initPath(MultiPath path, double radius) {
        return (MultiPath)((MultiPath)path.rect(0.0, 0.0, radius * 2.0, radius * 2.0).setStrokeWidth(0.0)).setStrokeAlpha(0.0);
    }

    private static double getOuterRadius(double radius) {
        return radius;
    }

    private static double getInnerRadius(double radius) {
        return radius / 2.0;
    }
}

