/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.view;

import com.google.gwt.safehtml.shared.SafeUri;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.shapes.client.factory.PictureProvidersManager;
import org.kie.workbench.common.stunner.shapes.client.view.CircleView;
import org.kie.workbench.common.stunner.shapes.client.view.ConnectorView;
import org.kie.workbench.common.stunner.shapes.client.view.PictureShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.PolygonView;
import org.kie.workbench.common.stunner.shapes.client.view.RectangleView;
import org.kie.workbench.common.stunner.shapes.client.view.RingView;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class ShapeViewFactory {
    private final PictureProvidersManager pictureProvidersManager;

    protected ShapeViewFactory() {
        this(null);
    }

    @Inject
    public ShapeViewFactory(PictureProvidersManager pictureProvidersManager) {
        this.pictureProvidersManager = pictureProvidersManager;
    }

    public RectangleView rectangle(double width, double height, double corner_radius) {
        return new RectangleView(width, height, corner_radius);
    }

    public PictureShapeView pictureFromUri(SafeUri uri, double width, double height) {
        PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        return new PictureShapeView(uri.asString(), width, height);
    }

    public PictureShapeView picture(Object source, double width, double height) {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        SafeUri uri = this.pictureProvidersManager.getUri(source);
        return new PictureShapeView(uri.asString(), width, height);
    }

    public CircleView circle(double radius) {
        return new CircleView(radius);
    }

    public RingView ring(double outer) {
        return new RingView(outer);
    }

    public PolygonView polygon(double radius, String fillColor) {
        return new PolygonView(radius, fillColor);
    }

    public ConnectorView connector(double ... points) {
        return new ConnectorView(points);
    }
}

