/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.shapes.client.factory;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFunctionalFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.shapes.client.BasicConnectorShape;
import org.kie.workbench.common.stunner.shapes.client.BasicContainerShape;
import org.kie.workbench.common.stunner.shapes.client.PictureShape;
import org.kie.workbench.common.stunner.shapes.client.RingShape;
import org.kie.workbench.common.stunner.shapes.client.view.AbstractConnectorView;
import org.kie.workbench.common.stunner.shapes.client.view.CircleView;
import org.kie.workbench.common.stunner.shapes.client.view.PictureShapeView;
import org.kie.workbench.common.stunner.shapes.client.view.PolygonView;
import org.kie.workbench.common.stunner.shapes.client.view.RectangleView;
import org.kie.workbench.common.stunner.shapes.client.view.RingView;
import org.kie.workbench.common.stunner.shapes.client.view.ShapeViewFactory;
import org.kie.workbench.common.stunner.shapes.def.BasicShapeDef;
import org.kie.workbench.common.stunner.shapes.def.CircleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.ConnectorShapeDef;
import org.kie.workbench.common.stunner.shapes.def.PolygonShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RectangleShapeDef;
import org.kie.workbench.common.stunner.shapes.def.RingShapeDef;
import org.kie.workbench.common.stunner.shapes.def.picture.PictureShapeDef;

@ApplicationScoped
public class BasicShapesFactory
implements ShapeDefFactory<Object, BasicShapeDef<Object>, Shape<ShapeView>> {
    private final ShapeDefFunctionalFactory<Object, BasicShapeDef, Shape> functionalFactory;
    private final ShapeViewFactory shapeViewFactory;

    protected BasicShapesFactory() {
        this(null, null);
    }

    @Inject
    public BasicShapesFactory(ShapeDefFunctionalFactory<Object, BasicShapeDef, Shape> functionalFactory, ShapeViewFactory shapeViewFactory) {
        this.functionalFactory = functionalFactory;
        this.shapeViewFactory = shapeViewFactory;
    }

    @PostConstruct
    public void init() {
        this.functionalFactory.set(CircleShapeDef.class, this::newCircle).set(RingShapeDef.class, this::newRing).set(RectangleShapeDef.class, this::newRectangle).set(PolygonShapeDef.class, this::newPolygon).set(ConnectorShapeDef.class, this::newConnector).set(PictureShapeDef.class, this::newPicture);
    }

    public Shape<ShapeView> newShape(Object instance, BasicShapeDef<Object> shapeDef) {
        return this.functionalFactory.newShape(instance, shapeDef);
    }

    private Shape<ShapeView> newCircle(Object instance, BasicShapeDef shapeDef) {
        CircleShapeDef circleShapeDef = (CircleShapeDef)shapeDef;
        double radius = circleShapeDef.getRadius(instance);
        CircleView view = this.shapeViewFactory.circle(radius);
        return new BasicContainerShape(circleShapeDef, view);
    }

    private Shape<ShapeView> newRing(Object instance, BasicShapeDef shapeDef) {
        RingShapeDef ringShapeDef = (RingShapeDef)shapeDef;
        double oRadius = ringShapeDef.getOuterRadius(instance);
        RingView view = this.shapeViewFactory.ring(oRadius);
        return new RingShape(ringShapeDef, view);
    }

    private Shape<ShapeView> newRectangle(Object instance, BasicShapeDef shapeDef) {
        RectangleShapeDef rectShapeDef = (RectangleShapeDef)shapeDef;
        double width = rectShapeDef.getWidth(instance);
        double height = rectShapeDef.getHeight(instance);
        double cr = rectShapeDef.getCornerRadius(instance);
        RectangleView view = this.shapeViewFactory.rectangle(width, height, cr);
        return new BasicContainerShape(rectShapeDef, view);
    }

    private Shape<ShapeView> newPolygon(Object instance, BasicShapeDef shapeDef) {
        PolygonShapeDef polygonShapeDef = (PolygonShapeDef)shapeDef;
        double radius = polygonShapeDef.getRadius(instance);
        PolygonView view = this.shapeViewFactory.polygon(radius);
        return new BasicContainerShape(polygonShapeDef, view);
    }

    private Shape<ShapeView> newConnector(Object instance, BasicShapeDef shapeDef) {
        ConnectorShapeDef cShapeDef = (ConnectorShapeDef)shapeDef;
        AbstractConnectorView view = this.shapeViewFactory.connector(0.0, 0.0, 100.0, 100.0);
        return new BasicConnectorShape(cShapeDef, view);
    }

    private Shape newPicture(Object instance, BasicShapeDef shapeDef) {
        PictureShapeDef pictShapeDef = (PictureShapeDef)shapeDef;
        Object pictureSource = pictShapeDef.getPictureSource(instance);
        double width = pictShapeDef.getWidth(instance);
        double height = pictShapeDef.getHeight(instance);
        PictureShapeView view = this.shapeViewFactory.picture(pictureSource, width, height);
        return new PictureShape(view);
    }
}

