/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.svg.gen.codegen.ViewFactoryGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.ViewGenerators;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewFactory;
import org.uberfire.annotations.processors.exceptions.GenerationException;

public class SVGViewFactoryGenerator
extends AbstractGenerator
implements ViewFactoryGenerator {
    @Override
    public StringBuffer generate(ViewFactory viewFactory) throws GeneratorException {
        LinkedList viewBuffers = new LinkedList();
        String name = viewFactory.getSimpleName();
        String pkg = viewFactory.getPackage();
        List<ViewDefinition<?>> viewDefinitions = viewFactory.getViewDefinitions();
        viewDefinitions.stream().forEach(viewDefinition -> {
            try {
                StringBuffer viewBuffer = this.generateView(viewFactory, (ViewDefinition)viewDefinition);
                viewBuffers.add(viewBuffer);
            }
            catch (GeneratorException e) {
                throw new RuntimeException(e);
            }
        });
        LinkedList viewsContent = new LinkedList();
        viewBuffers.forEach(b -> viewsContent.add(b.toString()));
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("genClassName", this.getClass().getName());
        root.put("name", name);
        root.put("pkg", pkg);
        root.put("implementedTypeName", viewFactory.getImplementedType());
        root.put("fmethods", viewsContent);
        StringBuffer result = null;
        try {
            result = this.writeTemplate(root);
        }
        catch (GenerationException e) {
            throw new GeneratorException(e);
        }
        return result;
    }

    private StringBuffer generateView(ViewFactory viewFactory, ViewDefinition viewDefinition) throws GeneratorException {
        return ViewGenerators.newShapeViewGenerator().generate(viewFactory, viewDefinition);
    }

    @Override
    protected String getTemplatePath() {
        return "SVGShapeViewFactory";
    }
}

