/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.css;

import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.TransformDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.StyleDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.model.impl.TransformDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParserUtils;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGStyleTranslatorHelper {
    private static final String TRANSFORM_SCALE = "scale";
    private static final String TRANSFORM_TRANSLATE = "translate";
    private static final Pattern TRANSFORM_PATTERN = Pattern.compile("(.*)\\((.*),(.*)\\)");
    public static final String OPACITY = "opacity";
    public static final String FILL = "fill";
    public static final String FILL_OPACITY = "fill-opacity";
    public static final String STROKE = "stroke";
    public static final String STROKE_OPACITY = "stroke-opacity";
    public static final String STROKE_WIDTH = "stroke-width";
    public static final String STYLE = "style";
    public static final String TRANSFORM = "transform";
    public static final String ATTR_VALUE_NONE = "none";
    public static final String[] ATTR_NAMES = new String[]{"opacity", "fill", "fill-opacity", "stroke", "stroke-opacity", "stroke-width"};

    public static TransformDefinition parseTransformDefinition(Element element) throws TranslatorException {
        String transformRaw = element.getAttribute(TRANSFORM);
        if (!SVGStyleTranslatorHelper.isEmpty(transformRaw)) {
            double[] t = SVGStyleTranslatorHelper.parseTransform(transformRaw);
            return new TransformDefinitionImpl(t[0], t[1], t[2], t[3]);
        }
        return new TransformDefinitionImpl();
    }

    private static double[] parseTransform(String raw) throws TranslatorException {
        String[] split;
        double sx = 1.0;
        double sy = 1.0;
        double tx = 0.0;
        double ty = 0.0;
        for (String transformDec : split = raw.split(" ")) {
            Matcher m = TRANSFORM_PATTERN.matcher(transformDec);
            if (m.matches()) {
                String op = m.group(1).trim();
                String x = m.group(2).trim();
                String y = m.group(3).trim();
                switch (op) {
                    case "scale": {
                        sx = SVGAttributeParserUtils.toPixelValue(x);
                        sy = SVGAttributeParserUtils.toPixelValue(y);
                        break;
                    }
                    case "translate": {
                        tx = SVGAttributeParserUtils.toPixelValue(x);
                        ty = SVGAttributeParserUtils.toPixelValue(y);
                    }
                }
                continue;
            }
            throw new TranslatorException("Unrecognized transform attribute value format [" + raw + "]");
        }
        return new double[]{sx, sy, tx, ty};
    }

    public static StyleDefinition parseStyleDefinition(Element element) throws TranslatorException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ATTR_NAMES.length; ++i) {
            String key = ATTR_NAMES[i];
            String value = element.getAttribute(key);
            if (SVGStyleTranslatorHelper.isEmpty(value)) continue;
            builder.append(key).append(": ").append(value).append("; ");
        }
        String styleRaw = element.getAttribute(STYLE);
        if (!SVGStyleTranslatorHelper.isEmpty(styleRaw)) {
            builder.append(styleRaw);
        }
        if (0 < builder.length()) {
            return SVGStyleTranslatorHelper.parseStyleDefinition(builder.toString());
        }
        return new StyleDefinitionImpl.Builder().build();
    }

    public static StyleDefinition parseStyleDefinition(String styleRaw) throws TranslatorException {
        CSSStyleSheetImpl sheet = SVGStyleTranslatorHelper.parseStyleSheet(styleRaw);
        CSSRuleList cssRules = sheet.getCssRules();
        for (int i = 0; i < cssRules.getLength(); ++i) {
            CSSRule item = cssRules.item(i);
            if (1 != item.getType()) continue;
            CSSStyleRuleImpl rule = (CSSStyleRuleImpl)item;
            String selectorText = rule.getSelectorText();
            System.out.println("- " + selectorText);
            CSSStyleDeclaration declaration = rule.getStyle();
            return SVGStyleTranslatorHelper.parseStyleDefinition(declaration);
        }
        return null;
    }

    private static CSSStyleSheetImpl parseStyleSheet(String style) throws TranslatorException {
        try {
            String declaration = ".shape { " + style + "}";
            InputSource source = new InputSource((Reader)new StringReader(declaration));
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            return (CSSStyleSheetImpl)parser.parseStyleSheet(source, null, null);
        }
        catch (IOException e) {
            throw new TranslatorException("Exception while parsing some style defintion.", e);
        }
    }

    private static StyleDefinition parseStyleDefinition(CSSStyleDeclaration declaration) {
        StyleDefinitionImpl.Builder builder = new StyleDefinitionImpl.Builder();
        boolean isFillNone = false;
        boolean isStrokeNone = false;
        block16: for (int j = 0; j < declaration.getLength(); ++j) {
            String property = declaration.item(j).trim();
            String value = declaration.getPropertyValue(property).trim();
            switch (property) {
                case "opacity": {
                    builder.setAlpha(SVGAttributeParserUtils.toPixelValue(value));
                    continue block16;
                }
                case "fill": {
                    if (ATTR_VALUE_NONE.equals(value)) {
                        isFillNone = true;
                        continue block16;
                    }
                    builder.setFillColor(SVGAttributeParserUtils.toHexColorString(value));
                    continue block16;
                }
                case "fill-opacity": {
                    builder.setFillAlpha(SVGAttributeParserUtils.toPixelValue(value));
                    continue block16;
                }
                case "stroke": {
                    if (ATTR_VALUE_NONE.equals(value)) {
                        isStrokeNone = true;
                        continue block16;
                    }
                    builder.setStrokeColor(SVGAttributeParserUtils.toHexColorString(value));
                    continue block16;
                }
                case "stroke-opacity": {
                    builder.setStrokeAlpha(SVGAttributeParserUtils.toPixelValue(value));
                    continue block16;
                }
                case "stroke-width": {
                    builder.setStrokeWidth(SVGAttributeParserUtils.toPixelValue(value));
                }
            }
        }
        if (isFillNone) {
            builder.setFillAlpha(0.0);
        }
        if (isStrokeNone) {
            builder.setStrokeAlpha(0.0);
        }
        return builder.build();
    }

    private static boolean isEmpty(String s) {
        return StringUtils.isEmpty((CharSequence)s);
    }
}

