/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.impl;

import java.util.LinkedList;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGDocumentTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGElementTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParserUtils;
import org.kie.workbench.common.stunner.svg.gen.translator.impl.SVGTranslatorContextImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.impl.SVGViewBoxTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGDocumentTranslatorImpl
implements SVGDocumentTranslator {
    private static final String SVG_TAG = "svg";
    public static final String X = "x";
    public static final double X_DEFAULT = 0.0;
    public static final String Y = "y";
    public static final double Y_DEFAULT = 0.0;
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String VIEW_BOX = "viewBox";
    private final SVGElementTranslator<Element, Object>[] elementTranslators;

    public SVGDocumentTranslatorImpl(SVGElementTranslator<Element, Object>[] elementTranslators) {
        this.elementTranslators = elementTranslators;
    }

    @Override
    public Class<Document> getInputType() {
        return Document.class;
    }

    @Override
    public ViewDefinition<SVGShapeView> translate(Document root) throws TranslatorException {
        PrimitiveDefinition main;
        SVGTranslatorContextImpl context = new SVGTranslatorContextImpl(root, this.elementTranslators);
        String svgId = null;
        double[] svgCoord = new double[]{0.0, 0.0};
        double[] svgSize = new double[]{0.0, 0.0};
        ViewDefinition.ViewBoxDefinition[] viewBox = new ViewDefinition.ViewBoxDefinition[1];
        NodeList svgNodes = root.getElementsByTagName(SVG_TAG);
        if (null == svgNodes || 1 != svgNodes.getLength()) {
            throw new TranslatorException("No SVG root node found!");
        }
        Element svgNode = (Element)svgNodes.item(0);
        svgId = svgNode.getAttribute(X);
        String x = svgNode.getAttribute(X);
        String y = svgNode.getAttribute(Y);
        SVGElementTranslator<Element, Object>[] width = svgNode.getAttribute(WIDTH);
        String height = svgNode.getAttribute(HEIGHT);
        svgCoord[0] = SVGAttributeParserUtils.toPixelValue(x, 0.0);
        svgCoord[1] = SVGAttributeParserUtils.toPixelValue(y, 0.0);
        svgSize[0] = SVGAttributeParserUtils.toPixelValue((String)width);
        svgSize[1] = SVGAttributeParserUtils.toPixelValue(height);
        String vbox = svgNode.getAttribute(VIEW_BOX);
        viewBox[0] = SVGViewBoxTranslator.translate(vbox);
        PrimitiveDefinition potentialMainShape = null;
        PrimitiveDefinition mainShape = null;
        LinkedList<PrimitiveDefinition> result = new LinkedList<PrimitiveDefinition>();
        for (SVGElementTranslator<Element, Object> translator : this.elementTranslators) {
            String tagName = translator.getTagName();
            NodeList nodes = root.getElementsByTagName(tagName);
            if (null == nodes || 0 >= nodes.getLength()) continue;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element node = (Element)nodes.item(i);
                Object definition = translator.translate(node, context);
                if (null == definition) continue;
                if (definition instanceof PrimitiveDefinition) {
                    PrimitiveDefinition primitiveDefinition = (PrimitiveDefinition)definition;
                    if (primitiveDefinition.isMain()) {
                        mainShape = primitiveDefinition;
                        continue;
                    }
                    if (null == potentialMainShape) {
                        potentialMainShape = primitiveDefinition;
                        continue;
                    }
                    result.add(primitiveDefinition);
                    continue;
                }
                if (!(definition instanceof ViewRefDefinition)) continue;
                context.addSVGViewRef((ViewRefDefinition)definition);
            }
        }
        if (null != mainShape && null != potentialMainShape) {
            result.add(potentialMainShape);
        }
        PrimitiveDefinition primitiveDefinition = main = null != mainShape ? mainShape : potentialMainShape;
        if (null == main) {
            throw new TranslatorException("No SVG main node found!!");
        }
        ViewDefinitionImpl viewDefinition = new ViewDefinitionImpl(svgId, svgCoord[0], svgCoord[1], svgSize[0], svgSize[1], viewBox[0], main, result.toArray(new PrimitiveDefinition[result.size()]));
        viewDefinition.getSVGViewRefs().addAll(context.viewRefDefinitions);
        return viewDefinition;
    }
}

