/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import org.kie.workbench.common.stunner.svg.gen.codegen.PrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.TransformDefinition;

public abstract class AbstractPrimitiveDefinitionGenerator<I extends PrimitiveDefinition<?>>
extends AbstractGenerator
implements PrimitiveDefinitionGenerator<I> {
    private static final String NON_DRAGGABLE = ".setDraggable(false)";
    private static final String LISTENING = ".setListening(%1s)";
    private static final String ID = ".setID(\"%1s\")";
    private static final String X = ".setX(%1s)";
    private static final String Y = ".setY(%1s)";
    private static final String ALPHA = ".setAlpha(%1s)";
    private static final String SCALE = ".setScale(%1s,%2s)";
    private static final String TRANSLATE = ".setOffset(%1s,%2s)";

    protected abstract StringBuffer doGenerate(I var1) throws GeneratorException;

    @Override
    public StringBuffer generate(I input) throws GeneratorException {
        StringBuffer shapeRaw = this.doGenerate(input);
        this.appendDraggable(shapeRaw, input);
        this.appendId(shapeRaw, input);
        this.appendCoordinates(shapeRaw, input);
        this.appendOpacity(shapeRaw, input);
        this.appendListening(shapeRaw, input);
        this.appendTransform(shapeRaw, input);
        return shapeRaw;
    }

    protected void appendDraggable(StringBuffer buffer, I input) {
        buffer.append(NON_DRAGGABLE);
    }

    protected void appendId(StringBuffer buffer, I input) {
        String id = input.getId();
        if (null != id && id.trim().length() > 0) {
            buffer.append(this.formatString(ID, id));
        }
    }

    protected void appendCoordinates(StringBuffer buffer, I input) {
        buffer.append(this.formatDouble(X, input.getX()));
        buffer.append(this.formatDouble(Y, input.getY()));
    }

    protected void appendOpacity(StringBuffer buffer, I input) {
        buffer.append(this.formatDouble(ALPHA, input.getAlpha()));
    }

    protected void appendListening(StringBuffer buffer, I input) {
        buffer.append(this.formatString(LISTENING, Boolean.toString(input.isListening())));
    }

    protected void appendTransform(StringBuffer buffer, I input) {
        TransformDefinition transformDefinition = input.getTransformDefinition();
        if (null != transformDefinition) {
            buffer.append(this.formatDouble(SCALE, transformDefinition.getScaleX(), transformDefinition.getScaleY()));
            buffer.append(this.formatDouble(TRANSLATE, transformDefinition.getTranslateX(), transformDefinition.getTranslateY()));
        }
    }
}

