/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.impl;

import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.impl.RectDefinition;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGTranslatorContext;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParserUtils;
import org.kie.workbench.common.stunner.svg.gen.translator.impl.AbstractSVGShapeTranslator;
import org.w3c.dom.Element;

public class SVGRectTranslator
extends AbstractSVGShapeTranslator<Element, RectDefinition> {
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String RX = "rx";
    public static final String RY = "ry";

    @Override
    public Class<Element> getInputType() {
        return Element.class;
    }

    @Override
    public RectDefinition doTranslate(Element rectElement, SVGTranslatorContext context) throws TranslatorException {
        String rx = rectElement.getAttribute(RX);
        String ry = rectElement.getAttribute(RY);
        String width = rectElement.getAttribute(WIDTH);
        String height = rectElement.getAttribute(HEIGHT);
        return new RectDefinition(this.getId(rectElement), SVGAttributeParserUtils.toPixelValue(width), SVGAttributeParserUtils.toPixelValue(height), this.getCornerRadius(rx, ry));
    }

    @Override
    public String getTagName() {
        return "rect";
    }

    private double getCornerRadius(String rx, String ry) {
        double cy;
        double cx = SVGAttributeParserUtils.toPixelValue(rx, 0.0);
        return cx > (cy = SVGAttributeParserUtils.toPixelValue(ry, 0.0)) ? cx : cy;
    }
}

