/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.gen.codegen.PrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.ViewDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.ViewGenerators;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewFactory;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.uberfire.annotations.processors.exceptions.GenerationException;

public class SVGViewDefinitionGenerator
extends AbstractGenerator
implements ViewDefinitionGenerator<ViewDefinition<SVGShapeView>> {
    private static final String CHILD_TEMPLATE = "view.addSVGChild(\"%1s\", %1s.this.%1sBasicView());";

    @Override
    public StringBuffer generate(ViewFactory viewFactory, ViewDefinition<SVGShapeView> viewDefinition) throws GeneratorException {
        StringBuffer result = null;
        String factoryName = viewFactory.getSimpleName();
        String name = viewDefinition.getName();
        double x = viewDefinition.getX();
        double y = viewDefinition.getY();
        double width = viewDefinition.getWidth();
        double height = viewDefinition.getHeight();
        PrimitiveDefinition main = viewDefinition.getMain();
        ViewDefinition.ViewBoxDefinition viewBox = viewDefinition.getViewBox();
        if (null != main) {
            HashMap<String, Object> root = new HashMap<String, Object>();
            LinkedList shapes = new LinkedList();
            LinkedList scalableShapes = new LinkedList();
            PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> mainGenerator = this.getGenerator(main);
            StringBuffer mainBuffer = mainGenerator.generate(main);
            List<PrimitiveDefinition> children = viewDefinition.getChildren();
            if (null != children) {
                children.stream().forEach(child -> {
                    PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> childGenerator = this.getGenerator((PrimitiveDefinition)child);
                    try {
                        StringBuffer childBuffer = childGenerator.generate((PrimitiveDefinition<?>)child);
                        if (child.isScalable()) {
                            scalableShapes.add(childBuffer.toString());
                        } else {
                            if (null != child.getLayoutDefinition() && !child.getLayoutDefinition().equals((Object)LayoutDefinition.NONE)) {
                                childBuffer.append(", LayoutContainer.Layout.").append(child.getLayoutDefinition().name().toUpperCase());
                            }
                            shapes.add(childBuffer.toString());
                        }
                    }
                    catch (GeneratorException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            LinkedList rawChildren = new LinkedList();
            List<ViewRefDefinition> svgViewRefs = viewDefinition.getSVGViewRefs();
            svgViewRefs.forEach(viewRef -> {
                String parent = viewRef.getParent();
                String svgName = viewRef.getViewName();
                String viewName = this.getFactoryName(viewFactory, svgName);
                if (null != viewName) {
                    String childRaw = this.formatString(CHILD_TEMPLATE, parent, factoryName, viewName);
                    rawChildren.add(childRaw);
                }
            });
            root.put("name", name);
            root.put("main", mainBuffer.toString());
            root.put("width", this.formatDouble(viewDefinition.getWidth()));
            root.put("height", this.formatDouble(viewDefinition.getHeight()));
            root.put("children", shapes);
            root.put("scalableChildren", scalableShapes);
            root.put("rawChildren", rawChildren);
            try {
                result = this.writeTemplate(root);
            }
            catch (GenerationException e) {
                throw new GeneratorException(e);
            }
        }
        return result;
    }

    private String getFactoryName(ViewFactory viewFactory, String path) {
        List<ViewDefinition<?>> viewDefinitions = viewFactory.getViewDefinitions();
        ViewDefinition d = viewDefinitions.stream().filter(def -> def.getPath().endsWith(path)).findFirst().orElse(null);
        if (null != d) {
            return d.getName();
        }
        return null;
    }

    private PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> getGenerator(PrimitiveDefinition main) {
        PrimitiveDefinitionGenerator<?>[] array = ViewGenerators.newPrimitiveDefinitionGenerators();
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list.stream().filter(generator -> generator.getDefinitionType().equals(main.getClass())).findFirst().orElse(null);
    }

    @Override
    protected String getTemplatePath() {
        return "SVGShapeView";
    }
}

