/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.impl;

import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.gen.SVGGenerator;
import org.kie.workbench.common.stunner.svg.gen.SVGGeneratorRequest;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGViewFactoryGenerator;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewFactoryImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGDocumentTranslator;
import org.w3c.dom.Document;

public class SVGGeneratorImpl
implements SVGGenerator {
    private final SVGDocumentTranslator translator;
    private final SVGViewFactoryGenerator viewFactoryGenerator;
    private final DocumentBuilder documentBuilder;

    public SVGGeneratorImpl(SVGDocumentTranslator translator, SVGViewFactoryGenerator viewFactoryGenerator) throws ParserConfigurationException {
        this.translator = translator;
        this.viewFactoryGenerator = viewFactoryGenerator;
        this.documentBuilder = this.newBuilder();
    }

    @Override
    public StringBuffer generate(SVGGeneratorRequest request) throws GeneratorException {
        String name = request.getName();
        String pkg = request.getPkg();
        String typeOf = request.getImplementedType();
        Map<String, String> viewSources = request.getViewSources();
        ViewFactoryImpl viewFactory = new ViewFactoryImpl(name, pkg, typeOf);
        viewSources.entrySet().forEach(svgEntry -> {
            String svgName = (String)svgEntry.getKey();
            String svgPath = (String)svgEntry.getValue();
            InputStream svgStream = this.getClass().getClassLoader().getResourceAsStream(svgPath);
            if (null != svgStream) {
                try {
                    ViewDefinition<SVGShapeView> viewDefinition = this.parseSVGView(svgName, svgPath, svgStream);
                    viewFactory.getViewDefinitions().add(viewDefinition);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while processing the SVG [" + svgName + "]", e);
                }
            } else {
                throw new RuntimeException("No SVG file found at [" + svgPath + "]");
            }
        });
        return this.viewFactoryGenerator.generate(viewFactory);
    }

    private ViewDefinition<SVGShapeView> parseSVGView(String name, String svgPath, InputStream svgStream) throws Exception {
        ViewDefinition<SVGShapeView> svgShapeViewSource = null;
        try {
            Document root = this.parse(name, svgPath, svgStream);
            svgShapeViewSource = this.translate(name, svgPath, root);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        return svgShapeViewSource;
    }

    private Document parse(String name, String svgPath, InputStream inputStream) throws Exception {
        Document root = this.documentBuilder.parse(inputStream);
        root.getDocumentElement().normalize();
        return root;
    }

    private ViewDefinition<SVGShapeView> translate(String name, String svgPath, Document document) throws Exception {
        ViewDefinitionImpl viewDefinition = (ViewDefinitionImpl)this.translator.translate(document);
        viewDefinition.setName(name);
        viewDefinition.setPath(svgPath);
        return viewDefinition;
    }

    private DocumentBuilder newBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        documentFactory.setNamespaceAware(true);
        return documentFactory.newDocumentBuilder();
    }
}

