/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.impl;

import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.TransformDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.AbstractPrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGElementTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGTranslatorContext;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParserUtils;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGStyleTranslatorHelper;
import org.w3c.dom.Element;

public abstract class AbstractSVGPrimitiveTranslator<E extends Element, O extends AbstractPrimitiveDefinition<?>>
implements SVGElementTranslator<E, O> {
    private static final String ID = "id";
    private static final String X = "x";
    private static final String Y = "y";

    protected abstract O doTranslate(E var1, SVGTranslatorContext var2) throws TranslatorException;

    @Override
    public O translate(E element, SVGTranslatorContext context) throws TranslatorException {
        O def = this.doTranslate(element, context);
        if (null != def) {
            this.translatePrimitiveSpecific(element, def, context);
            this.translateLayout(element, def, context);
            this.translateStyles(element, def, context);
            this.translateTransforms(element, def, context);
        }
        return def;
    }

    protected void translatePrimitiveSpecific(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        this.translatePosition(element, def, context);
        String shapeRaw = element.getAttributeNS("http://www.kie.org/2017/stunner", "shape");
        boolean nonScalable = AbstractSVGPrimitiveTranslator.isEmpty(shapeRaw) || !"scalable-group".equalsIgnoreCase(shapeRaw);
        boolean isMainShape = !AbstractSVGPrimitiveTranslator.isEmpty(shapeRaw) && "main-shape".equalsIgnoreCase(shapeRaw);
        ((AbstractPrimitiveDefinition)def).setScalable(!nonScalable);
        ((AbstractPrimitiveDefinition)def).setMainShape(isMainShape);
    }

    protected void translatePosition(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        String xr = element.getAttribute(this.getXAttributeName());
        String yr = element.getAttribute(this.getYAttributeName());
        double x = SVGAttributeParserUtils.toPixelValue(xr, 0.0);
        double y = SVGAttributeParserUtils.toPixelValue(yr, 0.0);
        ((AbstractPrimitiveDefinition)def).setX(x);
        ((AbstractPrimitiveDefinition)def).setY(y);
    }

    protected String getXAttributeName() {
        return X;
    }

    protected String getYAttributeName() {
        return Y;
    }

    protected LayoutDefinition translateLayout(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        String layoutRaw = element.getAttributeNS("http://www.kie.org/2017/stunner", "layout");
        LayoutDefinition l = AbstractSVGPrimitiveTranslator.isEmpty(layoutRaw) ? LayoutDefinition.NONE : LayoutDefinition.valueOf(layoutRaw);
        ((AbstractPrimitiveDefinition)def).setLayoutDefinition(l);
        return l;
    }

    protected TransformDefinition translateTransforms(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        TransformDefinition transformDefinition = SVGStyleTranslatorHelper.parseTransformDefinition(element);
        ((AbstractPrimitiveDefinition)def).setTransformDefinition(transformDefinition);
        return transformDefinition;
    }

    protected StyleDefinition translateStyles(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        StyleDefinition styleDefinition = SVGStyleTranslatorHelper.parseStyleDefinition(element);
        ((AbstractPrimitiveDefinition)def).setAlpha(styleDefinition.getAlpha());
        return styleDefinition;
    }

    protected String getId(Element element) {
        return element.getAttribute(ID);
    }

    protected static void failIfEmpty(String key, String value) throws TranslatorException {
        if (AbstractSVGPrimitiveTranslator.isEmpty(value)) {
            throw new TranslatorException("Empty value for key [" + key + "]");
        }
    }

    protected static boolean isEmpty(String s) {
        return StringUtils.isEmpty((CharSequence)s);
    }
}

