/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.svg.gen.codegen.PrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGGeneratorFormatUtils;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.GroupDefinition;

public class SVGPrimitiveGeneratorUtils {
    public static final String NEW_SVG_CONTAINER_TEMPLATE = "SVGContainer %1s = SVGPrimitiveFactory.newSVGContainer(\"%1s\",%1s, %1s, %1s);";
    public static final String NEW_SVG_SHAPE_TEMPLATE = "SVGPrimitiveShape %1s = SVGPrimitiveFactory.newSVGPrimitiveShape(%1s, %1s, %1s);";
    public static final String GROUP_ADD_CHILD_TEMPLATE = "%1s.add(%1s);";
    public static Predicate<PrimitiveDefinition> CAN_GENERATE_PRIMITIVE_CODE = p -> p.getAlpha() > 0.0;

    public static String generateSvgPrimitive(String instanceId, Function<PrimitiveDefinition, PrimitiveDefinitionGenerator<PrimitiveDefinition<?>>> generatorProvider, PrimitiveDefinition child) {
        return SVGPrimitiveGeneratorUtils.generateSvgPrimitive(instanceId, generatorProvider, child, CAN_GENERATE_PRIMITIVE_CODE);
    }

    public static String generateSvgPrimitive(String instanceId, Function<PrimitiveDefinition, PrimitiveDefinitionGenerator<PrimitiveDefinition<?>>> generatorProvider, PrimitiveDefinition child, Predicate<PrimitiveDefinition> generationFilter) {
        String childRaw = null;
        try {
            StringBuffer childBuffer = generatorProvider.apply(child).generate(child);
            String scalableRaw = String.valueOf(child.isScalable());
            LayoutDefinition layoutDefinition = child.getLayoutDefinition();
            String childLayoutRaw = SVGPrimitiveGeneratorUtils.formatLayout(layoutDefinition);
            if (generationFilter.test(child)) {
                GroupDefinition groupDefinition;
                List<PrimitiveDefinition> children;
                if (child instanceof ShapeDefinition) {
                    childRaw = AbstractGenerator.formatString(NEW_SVG_SHAPE_TEMPLATE, instanceId, childBuffer.toString(), scalableRaw, childLayoutRaw);
                } else if (child instanceof GroupDefinition && (children = (groupDefinition = (GroupDefinition)child).getChildren()).stream().anyMatch(generationFilter)) {
                    childRaw = AbstractGenerator.formatString(NEW_SVG_CONTAINER_TEMPLATE, instanceId, groupDefinition.getId(), childBuffer.toString(), scalableRaw, childLayoutRaw);
                    for (PrimitiveDefinition childDef : children) {
                        String childDefInstanceId = SVGGeneratorFormatUtils.getValidInstanceId(childDef);
                        String childDefRaw = SVGPrimitiveGeneratorUtils.generateSvgPrimitive(childDefInstanceId, generatorProvider, childDef, generationFilter);
                        if (null == childDefRaw) continue;
                        childRaw = childRaw + childDefRaw;
                        childRaw = childRaw + AbstractGenerator.formatString(GROUP_ADD_CHILD_TEMPLATE, instanceId, childDefInstanceId);
                    }
                }
            }
        }
        catch (GeneratorException e) {
            throw new RuntimeException(e);
        }
        return childRaw;
    }

    public static String formatLayout(LayoutDefinition layoutDefinition) {
        return null != layoutDefinition && !LayoutDefinition.NONE.equals((Object)layoutDefinition) ? LayoutContainer.class.getName() + ".Layout." + layoutDefinition.name().toUpperCase() : "null";
    }
}

