/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.impl;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kie.workbench.common.stunner.svg.gen.SVGGenerator;
import org.kie.workbench.common.stunner.svg.gen.SVGGeneratorRequest;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGGeneratorFormatUtils;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGViewFactoryGenerator;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewFactoryImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGDocumentTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGTranslatorContext;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGStyleTranslator;
import org.w3c.dom.Document;

public class SVGGeneratorImpl
implements SVGGenerator {
    private final SVGDocumentTranslator translator;
    private final SVGViewFactoryGenerator viewFactoryGenerator;
    private final DocumentBuilder documentBuilder;

    public SVGGeneratorImpl(SVGDocumentTranslator translator, SVGViewFactoryGenerator viewFactoryGenerator) throws ParserConfigurationException {
        this.translator = translator;
        this.viewFactoryGenerator = viewFactoryGenerator;
        this.documentBuilder = this.newBuilder();
    }

    @Override
    public StringBuffer generate(SVGGeneratorRequest request) throws GeneratorException {
        InputStream cssStream;
        String name = request.getName();
        String pkg = request.getPkg();
        String typeOf = request.getImplementedType();
        String cssPath = request.getCssPath();
        Map<String, String> viewSources = request.getViewSources();
        ViewFactoryImpl viewFactory = new ViewFactoryImpl(name, pkg, typeOf);
        StyleSheetDefinition[] styleSheetDefinition = new StyleSheetDefinition[1];
        if (null != cssPath && cssPath.trim().length() > 0 && null != (cssStream = this.loadResource(cssPath))) {
            try {
                styleSheetDefinition[0] = SVGStyleTranslator.parseStyleSheetDefinition(cssPath, cssStream);
                viewFactory.setStyleSheetDefinition(styleSheetDefinition[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing the glocal CSS file [" + cssPath + "] ", e);
            }
        }
        LinkedHashSet processedSvgIds = new LinkedHashSet();
        viewSources.forEach((fMethodName, svgPath) -> {
            this.parseSVGViewSource((String)fMethodName, (String)svgPath, styleSheetDefinition[0], result -> {
                result.setId((String)fMethodName);
                result.setFactoryMethodName((String)fMethodName);
                viewFactory.getViewDefinitions().add((ViewDefinition<?>)result);
            });
            processedSvgIds.add(fMethodName);
        });
        LinkedList referencedViewDefinitions = new LinkedList();
        viewFactory.getViewDefinitions().stream().flatMap(v -> v.getSVGViewRefs().stream()).filter(vd -> !processedSvgIds.contains(vd.getViewRefId())).forEach(vd -> this.parseSVGViewSource(vd.getViewRefId(), vd.getFilePath(), styleSheetDefinition[0], result -> {
            String id = SVGGeneratorFormatUtils.getValidInstanceId(result);
            result.setFactoryMethodName(id);
            referencedViewDefinitions.add(result);
            processedSvgIds.add(id);
        }));
        viewFactory.getViewDefinitions().addAll(referencedViewDefinitions);
        return this.viewFactoryGenerator.generate(viewFactory);
    }

    private void parseSVGViewSource(String viewId, String svgPath, StyleSheetDefinition styleSheetDefinition, Consumer<ViewDefinitionImpl> viewDefinitionConsumer) {
        InputStream svgStream = this.loadResource(svgPath);
        if (null != svgStream) {
            try {
                ViewDefinitionImpl viewDefinition = this.parseSVGView(viewId, svgPath, svgStream, styleSheetDefinition);
                viewDefinitionConsumer.accept(viewDefinition);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing the SVG file [" + svgPath + "]", e);
            }
        } else {
            throw new RuntimeException("No SVG file found at [" + svgPath + "]");
        }
    }

    private InputStream loadResource(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    private ViewDefinitionImpl parseSVGView(String viewId, String svgPath, InputStream svgStream, StyleSheetDefinition styleSheetDefinition) throws Exception {
        ViewDefinitionImpl svgShapeViewSource = null;
        try {
            Document root = this.parse(svgStream);
            svgShapeViewSource = this.translate(viewId, svgPath, root, styleSheetDefinition);
        }
        catch (Exception e) {
            throw new GeneratorException(e);
        }
        return svgShapeViewSource;
    }

    private Document parse(InputStream inputStream) throws Exception {
        Document root = this.documentBuilder.parse(inputStream);
        root.getDocumentElement().normalize();
        return root;
    }

    private ViewDefinitionImpl translate(String viewId, String svgPath, Document document, StyleSheetDefinition styleSheetDefinition) throws Exception {
        Path path = Paths.get(svgPath, new String[0]);
        String relativePath = path.getNameCount() > 1 ? path.subpath(0, path.getNameCount() - 1).toString() : "";
        SVGTranslatorContext context = new SVGTranslatorContext(document, relativePath, styleSheetDefinition);
        if (null != viewId) {
            context.setViewId(viewId);
        }
        ViewDefinitionImpl viewDefinition = (ViewDefinitionImpl)this.translator.translate(context);
        viewDefinition.setPath(svgPath);
        viewDefinition.getStaticFields().putAll(context.getStaticStringMembers());
        return viewDefinition;
    }

    private DocumentBuilder newBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        documentFactory.setNamespaceAware(true);
        return documentFactory.newDocumentBuilder();
    }
}

