/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.css;

import com.ait.lienzo.shared.core.types.Color;
import com.ait.lienzo.shared.core.types.ColorName;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SVGAttributeParser {
    private static final Pattern RBG_PATTERN = Pattern.compile("rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)");

    public static double toPixelValue(String value, double defaultValue) {
        if (SVGAttributeParser.isEmpty(value)) {
            return defaultValue;
        }
        return SVGAttributeParser.toPixelValue(value);
    }

    public static double toPixelValue(String value) {
        if (value.endsWith("px") || value.endsWith("PX")) {
            return SVGAttributeParser.parseDouble(value.substring(0, value.length() - 2));
        }
        return SVGAttributeParser.parseDouble(value);
    }

    public static String toHexColorString(String raw) {
        Color color;
        Matcher m;
        if (raw.startsWith("#")) {
            return "#" + StringUtils.leftPad((String)raw.substring(1, raw.length()), (int)6, (String)"0");
        }
        if (raw.startsWith("rgb") && (m = RBG_PATTERN.matcher(raw)).matches()) {
            int r = Integer.valueOf(m.group(1));
            int g = Integer.valueOf(m.group(2));
            int b = Integer.valueOf(m.group(3));
            return SVGAttributeParser.rgbToHexString(r, g, b);
        }
        ColorName name = ColorName.lookup((String)raw);
        Color color2 = color = null != name ? ColorName.lookup((String)raw).getColor() : null;
        if (null != color) {
            return SVGAttributeParser.rgbToHexString(color.getR(), color.getG(), color.getB());
        }
        throw new RuntimeException("RGB value cannot be parsed! [" + raw + "]");
    }

    public static String rgbToHexString(int r, int g, int b) {
        return SVGAttributeParser.rgbToHexString(r, g, b, 1);
    }

    public static String rgbToHexString(int r, int g, int b, int a) {
        int rgb = SVGAttributeParser.toRGB(r, g, b, a);
        return SVGAttributeParser.rgbToHexString(rgb);
    }

    public static String rgbToHexString(int rgb) {
        String hex = Integer.toHexString(rgb & 0xFFFFFF);
        if (hex.length() < 6) {
            if (hex.length() == 5) {
                hex = "0" + hex;
            }
            if (hex.length() == 4) {
                hex = "00" + hex;
            }
            if (hex.length() == 3) {
                hex = "000" + hex;
            }
        }
        hex = "#" + hex;
        return SVGAttributeParser.toHexColorString(hex);
    }

    public static int toRGB(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    private static double parseDouble(String value) {
        return Double.parseDouble(value);
    }

    private static boolean isEmpty(String s) {
        return StringUtils.isEmpty((CharSequence)s);
    }
}

