/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGElementTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGTranslatorContext {
    private final Document root;
    private final String path;
    private final Optional<StyleSheetDefinition> cssStyleSheet;
    private String viewId;
    private String id;
    private SVGElementTranslator<Element, Object>[] elementTranslators;
    private final Map<String, String> staticStringMembers = new LinkedHashMap<String, String>();
    private final Set<ViewRefDefinition> viewRefDefinitions = new LinkedHashSet<ViewRefDefinition>();

    public SVGTranslatorContext(Document root, String path, StyleSheetDefinition cssStyleSheet) {
        this.cssStyleSheet = Optional.ofNullable(cssStyleSheet);
        this.root = root;
        this.path = path;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public void setSVGId(String id) {
        this.id = id;
    }

    public String getSVGId() {
        return this.id;
    }

    public Document getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public Optional<StyleSheetDefinition> getGlobalStyleSheet() {
        return this.cssStyleSheet;
    }

    public void setElementTranslators(SVGElementTranslator<Element, Object>[] elementTranslators) {
        this.elementTranslators = elementTranslators;
    }

    public SVGElementTranslator<Element, Object> getElementTranslator(String tagName) {
        for (SVGElementTranslator<Element, Object> translator : this.elementTranslators) {
            if (!translator.getTagName().equals(tagName)) continue;
            return translator;
        }
        return null;
    }

    public void addSVGViewRef(ViewRefDefinition viewRef) {
        this.viewRefDefinitions.add(viewRef);
    }

    public Set<ViewRefDefinition> getViewRefDefinitions() {
        return this.viewRefDefinitions;
    }

    public void addStaticStringMember(String name, String value) {
        this.staticStringMembers.put(name, value);
    }

    public Map<String, String> getStaticStringMembers() {
        return this.staticStringMembers;
    }
}

