/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGGeneratorFormatUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;

public abstract class AbstractGenerator {
    protected static ExceptionInInitializerError INITIALIZER_EXCEPTION = null;
    protected Configuration config;

    public AbstractGenerator() {
        try {
            this.config = new Configuration();
            this.config.setClassForTemplateLoading(this.getClass(), "templates");
            this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        }
        catch (NoClassDefFoundError var2) {
            if (var2.getCause() == null) {
                var2.initCause(INITIALIZER_EXCEPTION);
            }
            throw var2;
        }
        catch (ExceptionInInitializerError var3) {
            INITIALIZER_EXCEPTION = var3;
            throw var3;
        }
    }

    protected abstract String getTemplatePath();

    protected StringBuffer writeTemplate(Map<String, Object> ctxt, String path) throws GenerationException {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = this.config.getTemplate(path + ".ftl");
            template.process(ctxt, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException((Throwable)ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException((Throwable)te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException((Throwable)ioe);
            }
        }
        return sw.getBuffer();
    }

    protected StringBuffer writeTemplate(Map<String, Object> ctxt) throws GenerationException {
        return this.writeTemplate(ctxt, this.getTemplatePath());
    }

    public static String formatString(String pattern, String ... values) {
        return String.format(pattern, values);
    }

    public static String formatDouble(String pattern, double ... values) {
        return SVGGeneratorFormatUtils.format(pattern, values);
    }

    public static String formatDouble(double value) {
        return SVGGeneratorFormatUtils.format(value);
    }
}

