/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.impl;

import java.util.LinkedList;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.AbstractShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.GroupDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGDocumentTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGElementTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGTranslatorContext;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParser;
import org.kie.workbench.common.stunner.svg.gen.translator.impl.SVGViewBoxTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGDocumentTranslatorImpl
implements SVGDocumentTranslator {
    private static final String SVG_TAG = "svg";
    public static final String ID = "id";
    public static final String X = "x";
    public static final double X_DEFAULT = 0.0;
    public static final String Y = "y";
    public static final double Y_DEFAULT = 0.0;
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String VIEW_BOX = "viewBox";
    private final SVGElementTranslator<Element, Object>[] elementTranslators;

    public SVGDocumentTranslatorImpl(SVGElementTranslator<Element, Object>[] elementTranslators) {
        this.elementTranslators = elementTranslators;
    }

    @Override
    public Class<Document> getInputType() {
        return Document.class;
    }

    @Override
    public ViewDefinition<SVGShapeView> translate(SVGTranslatorContext context) throws TranslatorException {
        Document root = context.getRoot();
        StyleSheetDefinition styleSheetDefinition = context.getGlobalStyleSheet().orElse(null);
        context.setElementTranslators(this.elementTranslators);
        double[] svgCoord = new double[]{0.0, 0.0};
        double[] svgSize = new double[]{0.0, 0.0};
        ViewDefinition.ViewBoxDefinition[] viewBox = new ViewDefinition.ViewBoxDefinition[1];
        NodeList svgNodes = root.getElementsByTagName(SVG_TAG);
        if (null != svgNodes && svgNodes.getLength() > 1) {
            throw new TranslatorException("Only a single SVG node supported.!");
        }
        if (null == svgNodes || svgNodes.getLength() == 0) {
            throw new TranslatorException("No SVG root node found!");
        }
        Element svgNode = (Element)svgNodes.item(0);
        String svgId = svgNode.getAttribute(ID);
        if (StringUtils.isEmpty((String)svgId)) {
            throw new TranslatorException("The SVG node must contain a valid ID attribute.");
        }
        context.setSVGId(svgId);
        if (null == context.getViewId()) {
            svgId = svgNode.getAttribute(ID);
            context.setViewId(svgId);
        }
        String x = svgNode.getAttribute(X);
        String y = svgNode.getAttribute(Y);
        String width = svgNode.getAttribute(WIDTH);
        if (StringUtils.isEmpty((String)width)) {
            throw new TranslatorException("The SVG node [" + svgId + "] must contain a valid WIDTH attribute.");
        }
        String height = svgNode.getAttribute(HEIGHT);
        if (StringUtils.isEmpty((String)height)) {
            throw new TranslatorException("The SVG node [" + svgId + "] must contain a valid HEIGHT attribute.");
        }
        svgCoord[0] = SVGAttributeParser.toPixelValue(x, 0.0);
        svgCoord[1] = SVGAttributeParser.toPixelValue(y, 0.0);
        svgSize[0] = SVGAttributeParser.toPixelValue(width);
        svgSize[1] = SVGAttributeParser.toPixelValue(height);
        String vbox = svgNode.getAttribute(VIEW_BOX);
        if (StringUtils.isEmpty((String)vbox)) {
            throw new TranslatorException("The SVG node [" + svgId + "] must contain a valid VIEWBOX attribute.");
        }
        viewBox[0] = SVGViewBoxTranslator.translate(vbox);
        ShapeDefinition main = null;
        LinkedList<PrimitiveDefinition> result = new LinkedList<PrimitiveDefinition>();
        NodeList nodes = svgNode.getChildNodes();
        if (null != nodes) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Object definition;
                Element element;
                SVGElementTranslator<Element, Object> translator;
                Node node = nodes.item(i);
                if (!(node instanceof Element) || null == (translator = context.getElementTranslator((element = (Element)node).getTagName())) || null == (definition = translator.translate(element, context))) continue;
                if (definition instanceof PrimitiveDefinition) {
                    PrimitiveDefinition primitiveDefinition = (PrimitiveDefinition)definition;
                    if (null == main) {
                        main = (ShapeDefinition)primitiveDefinition;
                        continue;
                    }
                    result.add(primitiveDefinition);
                    continue;
                }
                if (!(definition instanceof ViewRefDefinition)) continue;
                context.addSVGViewRef((ViewRefDefinition)definition);
            }
        }
        if (null == main) {
            throw new TranslatorException("No SVG main node found.");
        }
        if (main instanceof GroupDefinition) {
            throw new TranslatorException("Main node cannot be a group.");
        }
        if (main instanceof AbstractShapeDefinition) {
            ((AbstractShapeDefinition)main).setMainShape(true);
            ((AbstractShapeDefinition)main).setListening(true);
        }
        ViewDefinitionImpl viewDefinition = new ViewDefinitionImpl(svgId, svgCoord[0], svgCoord[1], svgSize[0], svgSize[1], styleSheetDefinition, viewBox[0], main, result.toArray(new PrimitiveDefinition[result.size()]));
        viewDefinition.getSVGViewRefs().addAll(context.getViewRefDefinitions());
        return viewDefinition;
    }
}

