/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;

public class SVGShapeTextCodeBuilder {
    private static final String CSS_SELECTOR_TEXT = "#text";
    private static final String TITLE_ALPHA = ".setTitleAlpha(%1sd);";
    private static final String TITLE_FONT_FAMILY = ".setTitleFontFamily(\"%1s\");";
    private static final String TITLE_FONT_SIZE = ".setTitleFontSize(%1sd);";
    private static final String TITLE_FONT_COLOR = ".setTitleFontColor(\"%1s\");";
    private static final String TITLE_STROKE_WIDTH = ".setTitleStrokeWidth(%1sd);";
    private static final String TITLE_STROKE_COLOR = ".setTitleStrokeColor(\"%1s\");";

    public static String generate(String viewInstanceName, String viewId, StyleSheetDefinition styleSheetDefinition) {
        StyleDefinition globalStyle = styleSheetDefinition.getStyle(CSS_SELECTOR_TEXT);
        StyleDefinition customStyle = styleSheetDefinition.getStyle("#" + viewId + " " + CSS_SELECTOR_TEXT);
        return null != globalStyle || null != customStyle ? SVGShapeTextCodeBuilder.generateTextSetters(viewInstanceName, globalStyle, customStyle) : "";
    }

    private static String generateTextSetters(String viewInstanceName, StyleDefinition globalStyle, StyleDefinition customStyle) {
        String strokeColor;
        Double strokeWidth;
        String fontColor;
        Double fontSize;
        String fontFamily;
        Double alpha;
        String result = "";
        Double d = alpha = null != customStyle ? customStyle.getAlpha() : globalStyle.getAlpha();
        if (null != alpha) {
            result = result + viewInstanceName + AbstractGenerator.formatDouble(TITLE_ALPHA, alpha);
        }
        String string = fontFamily = null != customStyle ? customStyle.getFontFamily() : globalStyle.getFontFamily();
        if (null != fontFamily) {
            result = result + viewInstanceName + AbstractGenerator.formatString(TITLE_FONT_FAMILY, fontFamily);
        }
        Double d2 = fontSize = null != customStyle ? customStyle.getFontSize() : globalStyle.getFontSize();
        if (null != fontSize) {
            result = result + viewInstanceName + AbstractGenerator.formatDouble(TITLE_FONT_SIZE, fontSize);
        }
        String string2 = fontColor = null != customStyle ? customStyle.getFillColor() : globalStyle.getFillColor();
        if (null != fontColor) {
            result = result + viewInstanceName + AbstractGenerator.formatString(TITLE_FONT_COLOR, fontColor);
        }
        Double d3 = strokeWidth = null != customStyle ? customStyle.getStrokeWidth() : globalStyle.getStrokeWidth();
        if (null != strokeWidth) {
            result = result + viewInstanceName + AbstractGenerator.formatDouble(TITLE_STROKE_WIDTH, strokeWidth);
        }
        String string3 = strokeColor = null != customStyle ? customStyle.getStrokeColor() : globalStyle.getStrokeColor();
        if (null != strokeColor) {
            result = result + viewInstanceName + AbstractGenerator.formatString(TITLE_STROKE_COLOR, strokeColor);
        }
        return result;
    }
}

