/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.css;

import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.TransformDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.StyleDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.model.impl.TransformDefinitionImpl;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParser;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGStyleTranslator {
    public static final String ID = "id";
    public static final String OPACITY = "opacity";
    public static final String FILL = "fill";
    public static final String FILL_OPACITY = "fill-opacity";
    public static final String STROKE = "stroke";
    public static final String STROKE_OPACITY = "stroke-opacity";
    public static final String STROKE_WIDTH = "stroke-width";
    public static final String FONT_FAMILY = "font-family";
    public static final String STROKE_DASHARRAY = "stroke-dasharray";
    public static final String FONT_SIZE = "font-size";
    public static final String STYLE = "style";
    public static final String CSS_CLASS = "class";
    public static final String TRANSFORM = "transform";
    public static final String ATTR_VALUE_NONE = "none";
    public static final String[] ATTR_NAMES = new String[]{"opacity", "fill", "fill-opacity", "stroke", "stroke-opacity", "stroke-width", "stroke-dasharray", "font-family", "font-size"};
    private static final String PATTERN_CLASSNAME_SEPARATOR = "\\s+";
    private static final String TRANSFORM_SCALE = "scale";
    private static final String TRANSFORM_TRANSLATE = "translate";
    private static final Pattern TRANSFORM_PATTERN = Pattern.compile("(.*)\\((.*),(.*)\\)");

    private SVGStyleTranslator() {
    }

    public static TransformDefinition parseTransformDefinition(Element element) throws TranslatorException {
        String transformRaw = element.getAttribute(TRANSFORM);
        if (!SVGStyleTranslator.isEmpty(transformRaw)) {
            double[] t = SVGStyleTranslator.parseTransform(transformRaw);
            return new TransformDefinitionImpl(t[0], t[1], t[2], t[3]);
        }
        return new TransformDefinitionImpl();
    }

    public static StyleSheetDefinition parseStyleSheetDefinition(String cssPath, InputStream cssStream) throws TranslatorException {
        CSSStyleSheetImpl sheet = SVGStyleTranslator.parseStyleSheet(new InputSource((Reader)new InputStreamReader(cssStream)));
        CSSRuleList cssRules = sheet.getCssRules();
        StyleSheetDefinition result = new StyleSheetDefinition(cssPath);
        for (int i = 0; i < cssRules.getLength(); ++i) {
            CSSRule item = cssRules.item(i);
            if (1 != item.getType()) continue;
            CSSStyleRuleImpl rule = (CSSStyleRuleImpl)item;
            String selectorText = rule.getSelectorText();
            CSSStyleDeclaration declaration = rule.getStyle();
            StyleDefinition styleDefinition = SVGStyleTranslator.parseStyleDefinition(declaration);
            result.addStyle(selectorText, styleDefinition);
        }
        return result;
    }

    public static StyleDefinition parseStyleDefinition(Element element, String svgId, StyleSheetDefinition styleSheetDefinition) throws TranslatorException {
        String cssClassRaw;
        String string = cssClassRaw = null != styleSheetDefinition ? SVGStyleTranslator.getStyleDeclaration(element) : null;
        if (!SVGStyleTranslator.isEmpty(cssClassRaw)) {
            List<String> elementSelectors = SVGStyleTranslator.parseAllSelectors(element);
            List<String> selectors = elementSelectors.stream().collect(Collectors.toList());
            for (String elementSelector : elementSelectors) {
                selectors.add("#" + svgId + " " + elementSelector);
            }
            StyleDefinition style = styleSheetDefinition.getStyle(selectors);
            return null != style ? style : SVGStyleTranslator.createDefaultStyleDefinition();
        }
        StringBuilder builder = new StringBuilder();
        for (String key : ATTR_NAMES) {
            String value = element.getAttribute(key);
            if (SVGStyleTranslator.isEmpty(value)) continue;
            builder.append(key).append(": ").append(value).append("; ");
        }
        String styleRaw = element.getAttribute(STYLE);
        if (!SVGStyleTranslator.isEmpty(styleRaw)) {
            builder.append(styleRaw);
        }
        if (0 < builder.length()) {
            return SVGStyleTranslator.parseElementStyleDefinition(builder.toString());
        }
        return SVGStyleTranslator.createDefaultStyleDefinition();
    }

    public static String[] getClassNames(Element element) {
        String raw = SVGStyleTranslator.getStyleDeclaration(element);
        if (!SVGStyleTranslator.isEmpty(raw)) {
            return raw.split(PATTERN_CLASSNAME_SEPARATOR);
        }
        return null;
    }

    private static StyleDefinition createDefaultStyleDefinition() {
        return new StyleDefinitionImpl.Builder().build();
    }

    private static double[] parseTransform(String raw) throws TranslatorException {
        String[] split;
        double sx = 1.0;
        double sy = 1.0;
        double tx = 0.0;
        double ty = 0.0;
        for (String transformDec : split = raw.split(" ")) {
            Matcher m = TRANSFORM_PATTERN.matcher(transformDec);
            if (m.matches()) {
                String op = m.group(1).trim();
                String x = m.group(2).trim();
                String y = m.group(3).trim();
                switch (op) {
                    case "scale": {
                        sx = SVGAttributeParser.toPixelValue(x);
                        sy = SVGAttributeParser.toPixelValue(y);
                        break;
                    }
                    case "translate": {
                        tx = SVGAttributeParser.toPixelValue(x);
                        ty = SVGAttributeParser.toPixelValue(y);
                    }
                }
                continue;
            }
            throw new TranslatorException("Unrecognized transform attribute value format [" + raw + "]");
        }
        return new double[]{sx, sy, tx, ty};
    }

    private static StyleDefinition parseElementStyleDefinition(String styleRaw) throws TranslatorException {
        CSSStyleSheetImpl sheet = SVGStyleTranslator.parseElementStyleSheet(styleRaw);
        CSSRuleList cssRules = sheet.getCssRules();
        for (int i = 0; i < cssRules.getLength(); ++i) {
            CSSRule item = cssRules.item(i);
            if (1 != item.getType()) continue;
            CSSStyleRuleImpl rule = (CSSStyleRuleImpl)item;
            CSSStyleDeclaration declaration = rule.getStyle();
            return SVGStyleTranslator.parseStyleDefinition(declaration);
        }
        return null;
    }

    private static CSSStyleSheetImpl parseElementStyleSheet(String style) throws TranslatorException {
        String declaration = ".shape { " + style + "}";
        return SVGStyleTranslator.parseStyleSheet(new InputSource((Reader)new StringReader(declaration)));
    }

    private static CSSStyleSheetImpl parseStyleSheet(InputSource source) throws TranslatorException {
        try {
            CSSOMParser parser = new CSSOMParser((Parser)new SACParserCSS3());
            return (CSSStyleSheetImpl)parser.parseStyleSheet(source, null, null);
        }
        catch (IOException e) {
            throw new TranslatorException("Exception while parsing some style defintion.", e);
        }
    }

    private static StyleDefinition parseStyleDefinition(CSSStyleDeclaration declaration) {
        StyleDefinitionImpl.Builder builder = new StyleDefinitionImpl.Builder();
        boolean isFillNone = false;
        boolean isStrokeNone = false;
        block22: for (int j = 0; j < declaration.getLength(); ++j) {
            String property = declaration.item(j).trim();
            String value = declaration.getPropertyValue(property).trim();
            switch (property) {
                case "opacity": {
                    builder.setAlpha(SVGAttributeParser.toPixelValue(value));
                    continue block22;
                }
                case "fill": {
                    if (ATTR_VALUE_NONE.equals(value)) {
                        isFillNone = true;
                        continue block22;
                    }
                    builder.setFillColor(SVGAttributeParser.toHexColorString(value));
                    continue block22;
                }
                case "fill-opacity": {
                    builder.setFillAlpha(SVGAttributeParser.toPixelValue(value));
                    continue block22;
                }
                case "stroke": {
                    if (ATTR_VALUE_NONE.equals(value)) {
                        isStrokeNone = true;
                        continue block22;
                    }
                    builder.setStrokeColor(SVGAttributeParser.toHexColorString(value));
                    continue block22;
                }
                case "stroke-opacity": {
                    builder.setStrokeAlpha(SVGAttributeParser.toPixelValue(value));
                    continue block22;
                }
                case "stroke-width": {
                    builder.setStrokeWidth(SVGAttributeParser.toPixelValue(value));
                    continue block22;
                }
                case "stroke-dasharray": {
                    builder.setStrokeDashArray(value);
                    continue block22;
                }
                case "font-family": {
                    builder.setFontFamily(value.trim());
                    continue block22;
                }
                case "font-size": {
                    builder.setFontSize(SVGAttributeParser.toPixelValue(value));
                }
            }
        }
        if (isFillNone) {
            builder.setFillAlpha(0.0);
        }
        if (isStrokeNone) {
            builder.setStrokeAlpha(0.0);
        }
        return builder.build();
    }

    static List<String> parseAllSelectors(Element element) {
        List<Element> elements = SVGStyleTranslator.getElementsTree(element);
        LinkedList<String> result = new LinkedList<String>();
        for (Element candidate : elements) {
            Collection<String> selectors = SVGStyleTranslator.parseElementSelectors(candidate);
            if (result.isEmpty()) {
                result.addAll(selectors);
                continue;
            }
            List parentSelectors = result.stream().collect(Collectors.toList());
            for (String selector : selectors) {
                for (String parentSelector : parentSelectors) {
                    result.add(selector + " " + parentSelector);
                }
            }
        }
        return result;
    }

    static List<Element> getElementsTree(Element element) {
        LinkedList<Element> tree = new LinkedList<Element>();
        tree.add(element);
        for (Node parent = element.getParentNode(); null != parent; parent = parent.getParentNode()) {
            if (!(parent instanceof Element)) continue;
            tree.add((Element)parent);
        }
        return tree;
    }

    static Collection<String> parseElementSelectors(Element element) {
        String id;
        LinkedList<String> result = new LinkedList<String>();
        String cssClassRaw = SVGStyleTranslator.getStyleDeclaration(element);
        if (!SVGStyleTranslator.isEmpty(cssClassRaw)) {
            Arrays.stream(cssClassRaw.split(PATTERN_CLASSNAME_SEPARATOR)).map(c -> "." + c).forEach(result::add);
        }
        if (!SVGStyleTranslator.isEmpty(id = element.getAttribute(ID))) {
            result.add("#" + id);
        }
        return result;
    }

    private static String getStyleDeclaration(Element element) {
        return element.getAttribute(CSS_CLASS);
    }

    private static boolean isEmpty(String s) {
        return StringUtils.isEmpty((CharSequence)s);
    }
}

