/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.impl;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.TransformDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.AbstractPrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGElementTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGTranslatorContext;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGAttributeParser;
import org.kie.workbench.common.stunner.svg.gen.translator.css.SVGStyleTranslator;
import org.w3c.dom.Element;

public abstract class AbstractSVGPrimitiveTranslator<E extends Element, O extends AbstractPrimitiveDefinition<?>>
implements SVGElementTranslator<E, O> {
    protected static final String ID = "id";
    protected static final String X = "x";
    protected static final String Y = "y";

    protected abstract O doTranslate(E var1, SVGTranslatorContext var2) throws TranslatorException;

    @Override
    public O translate(E element, SVGTranslatorContext context) throws TranslatorException {
        boolean excluded = this.translatePrimitiveExcluded(element);
        if (excluded) {
            return null;
        }
        O def = this.doTranslate(element, context);
        if (null != def) {
            this.translatePrimitiveDefinition(element, def, context);
            this.translateTransformDefinition(element, def);
            this.translateLayout(element, def);
            this.translateStyles(element, def, context);
            this.translateTransforms(element, def);
        }
        return def;
    }

    protected boolean translatePrimitiveExcluded(E element) {
        String shapeAttributeValue = this.getShapeAttributeValue(element);
        return !AbstractSVGPrimitiveTranslator.isEmpty(shapeAttributeValue) && "exclude".equalsIgnoreCase(shapeAttributeValue);
    }

    protected void translatePrimitiveDefinition(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        this.translatePosition(element, def, context);
    }

    String getShapeAttributeValue(E element) {
        return element.getAttributeNS("http://kiegroup.org/2017/stunner", "shape");
    }

    String getShapeStateAttributeValue(E element) {
        return element.getAttributeNS("http://kiegroup.org/2017/stunner", "shape-state");
    }

    protected void translateTransformDefinition(E element, O def) {
        boolean result = true;
        Object candidate = element;
        while (null != candidate) {
            if (candidate instanceof Element) {
                Optional<Boolean> scalable = this.isScalable((Element)candidate);
                if (scalable.isPresent()) {
                    result = scalable.get();
                    break;
                }
                candidate = candidate.getParentNode();
                continue;
            }
            candidate = null;
        }
        ((AbstractPrimitiveDefinition)def).setScalable(result);
    }

    private Optional<Boolean> isScalable(Element element) {
        String shapeRaw = element.getAttributeNS("http://kiegroup.org/2017/stunner", "transform");
        boolean empty = AbstractSVGPrimitiveTranslator.isEmpty(shapeRaw);
        if (!empty && "non-scalable".equalsIgnoreCase(shapeRaw)) {
            return Optional.of(false);
        }
        if (!empty && "scalable".equalsIgnoreCase(shapeRaw)) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    protected void translatePosition(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        String xr = element.getAttribute(this.getXAttributeName());
        String yr = element.getAttribute(this.getYAttributeName());
        double x = SVGAttributeParser.toPixelValue(xr, 0.0);
        double y = SVGAttributeParser.toPixelValue(yr, 0.0);
        ((AbstractPrimitiveDefinition)def).setX(x);
        ((AbstractPrimitiveDefinition)def).setY(y);
    }

    protected String getXAttributeName() {
        return X;
    }

    protected String getYAttributeName() {
        return Y;
    }

    protected LayoutDefinition translateLayout(E element, O def) {
        String layoutRaw = element.getAttributeNS("http://kiegroup.org/2017/stunner", "layout");
        LayoutDefinition l = AbstractSVGPrimitiveTranslator.isEmpty(layoutRaw) ? LayoutDefinition.NONE : LayoutDefinition.valueOf(layoutRaw);
        ((AbstractPrimitiveDefinition)def).setLayoutDefinition(l);
        return l;
    }

    protected TransformDefinition translateTransforms(E element, O def) throws TranslatorException {
        TransformDefinition transformDefinition = SVGStyleTranslator.parseTransformDefinition(element);
        ((AbstractPrimitiveDefinition)def).setTransformDefinition(transformDefinition);
        return transformDefinition;
    }

    protected StyleDefinition translateStyles(E element, O def, SVGTranslatorContext context) throws TranslatorException {
        StyleDefinition styleDefinition = SVGStyleTranslator.parseStyleDefinition(element, context.getViewId(), context.getGlobalStyleSheet().orElse(null));
        if (null != styleDefinition) {
            ((AbstractPrimitiveDefinition)def).setAlpha(null != styleDefinition.getAlpha() ? styleDefinition.getAlpha() : 1.0);
        }
        return styleDefinition;
    }

    protected static String getId(Element element) {
        String id = element.getAttribute(ID);
        Element parent = null;
        if (Objects.nonNull(element.getParentNode()) && element.getParentNode() instanceof Element) {
            parent = (Element)element.getParentNode();
        }
        if (!AbstractSVGPrimitiveTranslator.isEmpty(id)) {
            return id;
        }
        id = Objects.isNull(parent) ? "prim_" + UUID.uuid((int)4) : parent.getAttribute(ID) + "_" + element.getAttribute(ID) + "_" + UUID.uuid((int)4);
        element.setAttribute(ID, id);
        return id;
    }

    protected static void failIfEmpty(String key, String value) throws TranslatorException {
        if (AbstractSVGPrimitiveTranslator.isEmpty(value)) {
            throw new TranslatorException("Empty value for key [" + key + "]");
        }
    }

    protected static boolean isEmpty(String s) {
        return StringUtils.isEmpty((CharSequence)s);
    }
}

