/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.translator.impl;

import org.kie.workbench.common.stunner.svg.gen.exception.TranslatorException;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.GroupDefinition;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGElementTranslator;
import org.kie.workbench.common.stunner.svg.gen.translator.SVGTranslatorContext;
import org.kie.workbench.common.stunner.svg.gen.translator.impl.AbstractSVGPrimitiveTranslator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGGroupTranslator
extends AbstractSVGPrimitiveTranslator<Element, GroupDefinition>
implements SVGElementTranslator<Element, GroupDefinition> {
    @Override
    public String getTagName() {
        return "g";
    }

    @Override
    protected GroupDefinition doTranslate(Element element, SVGTranslatorContext context) throws TranslatorException {
        String id = SVGGroupTranslator.getId(element);
        GroupDefinition groupDefinition = new GroupDefinition(id);
        NodeList childNodes = element.getChildNodes();
        if (null != childNodes && childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element childElement;
                SVGElementTranslator<Element, Object> translator;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || null == (translator = context.getElementTranslator((childElement = (Element)child).getTagName()))) continue;
                Object childDefinition = translator.translate(childElement, context);
                if (childDefinition instanceof ViewRefDefinition) {
                    context.addSVGViewRef((ViewRefDefinition)childDefinition);
                    continue;
                }
                if (childDefinition instanceof ShapeDefinition) {
                    groupDefinition.getChildren().add((PrimitiveDefinition)childDefinition);
                    continue;
                }
                if (!(childDefinition instanceof GroupDefinition)) continue;
                throw new UnsupportedOperationException("Nested SVG groups are not allowed! [svgId=" + context.getSVGId() + "]");
            }
        }
        return groupDefinition;
    }

    @Override
    public Class<Element> getInputType() {
        return Element.class;
    }
}

