/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.model.impl;

import java.util.Collection;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.GroupDefinition;

public class SVGModelUtils {
    public static String toValidJavaId(String id) {
        return id.replaceAll("-", "_");
    }

    public static void visit(ViewDefinition<?> viewDefinition, Consumer<PrimitiveDefinition> definitionConsumer) {
        definitionConsumer.accept(viewDefinition);
        SVGModelUtils.visit(viewDefinition.getChildren(), definitionConsumer);
    }

    public static void visit(Collection<PrimitiveDefinition> definitions, Consumer<PrimitiveDefinition> definitionConsumer) {
        for (PrimitiveDefinition child : definitions) {
            if (child instanceof GroupDefinition) {
                SVGModelUtils.visit(((GroupDefinition)child).getChildren(), definitionConsumer);
                continue;
            }
            definitionConsumer.accept(child);
        }
    }
}

