/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.apt;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.kie.workbench.common.stunner.svg.annotation.SVGSource;
import org.kie.workbench.common.stunner.svg.annotation.SVGViewFactory;
import org.kie.workbench.common.stunner.svg.gen.SVGGenerator;
import org.kie.workbench.common.stunner.svg.gen.SVGGeneratorRequest;
import org.kie.workbench.common.stunner.svg.gen.apt.SVGShapeProcessorContext;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.impl.SVGGeneratorFactory;
import org.uberfire.annotations.processors.AbstractErrorAbsorbingProcessor;

@SupportedAnnotationTypes(value={"org.kie.workbench.common.stunner.svg.annotation.SVGViewFactory"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class SVGShapeProcessor
extends AbstractErrorAbsorbingProcessor {
    public static final String ANNOTATION_SVGSHAPE_VIEW_FACTORY = "org.kie.workbench.common.stunner.svg.annotation.SVGViewFactory";
    private static final String GENERATED_TYPE_SUFFIX = "Impl";
    private final SVGShapeProcessorContext context = new SVGShapeProcessorContext();
    private SVGGenerator generator;

    protected boolean processWithExceptions(Set<? extends TypeElement> set, RoundEnvironment roundEnv) throws Exception {
        if (roundEnv.processingOver()) {
            return this.processLastRound(set, roundEnv);
        }
        if (roundEnv.errorRaised()) {
            return false;
        }
        this.generator = SVGGeneratorFactory.newGenerator();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(elementUtils.getTypeElement(ANNOTATION_SVGSHAPE_VIEW_FACTORY))) {
            this.processSvgShapeViewFactory(set, element, roundEnv);
        }
        return true;
    }

    private boolean processSvgShapeViewFactory(Set<? extends TypeElement> set, Element e, RoundEnvironment roundEnv) throws Exception {
        boolean isIface;
        boolean bl = isIface = e.getKind() == ElementKind.INTERFACE;
        if (isIface) {
            TypeElement classElement = (TypeElement)e;
            PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
            String name = classElement.getSimpleName().toString();
            String packageName = packageElement.getQualifiedName().toString();
            String fqcn = packageName + "." + name;
            String absPkgPath = packageName.replaceAll("\\.", "/");
            this.note("Discovered @SVGViewFactory for type [" + fqcn + "]");
            SVGViewFactory svgViewFactoryAnn = classElement.getAnnotation(SVGViewFactory.class);
            SVGGeneratorRequest request = new SVGGeneratorRequest(name + GENERATED_TYPE_SUFFIX, packageName, fqcn, absPkgPath + "/" + svgViewFactoryAnn.value());
            this.context.setGeneratorRequest(request);
            List<ExecutableElement> methodElements = ElementFilter.methodsIn(classElement.getEnclosedElements());
            methodElements.forEach(methodElement -> {
                SVGSource svgSourceAnnotation = methodElement.getAnnotation(SVGSource.class);
                if (null != svgSourceAnnotation) {
                    String fileName = svgSourceAnnotation.value();
                    String absPath = absPkgPath + "/" + fileName;
                    String fieldName = methodElement.getSimpleName().toString();
                    this.note("Discovered @SVGSource to be processed at path [" + absPath + "]");
                    this.context.getGeneratorRequest().getViewSources().put(fieldName, absPath);
                }
            });
        }
        return true;
    }

    private boolean processLastRound(Set<? extends TypeElement> set, RoundEnvironment roundEnv) throws Exception {
        Messager messager = this.processingEnv.getMessager();
        try {
            SVGGeneratorRequest request = this.context.getGeneratorRequest();
            String classFQName = request.getPkg() + "." + request.getName();
            messager.printMessage(Diagnostic.Kind.NOTE, "Starting generation for SVGShapeViewFactory named [" + classFQName + "]");
            StringBuffer result = this.generator.generate(request);
            this.writeCode(request.getPkg(), request.getName(), result);
        }
        catch (GeneratorException ge) {
            String msg = ge.getMessage();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
        return true;
    }

    private void note(String message) {
        this.log(Diagnostic.Kind.NOTE, message);
    }

    private void warn(String message) {
        this.log(Diagnostic.Kind.WARNING, message);
    }

    private void error(String message) {
        this.log(Diagnostic.Kind.ERROR, message);
    }

    private void log(Diagnostic.Kind kind, String message) {
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(kind, message);
    }
}

