/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import org.kie.workbench.common.stunner.svg.gen.codegen.ShapeDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractPrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;

public abstract class AbstractShapeDefinitionGenerator<I extends ShapeDefinition<?>>
extends AbstractPrimitiveDefinitionGenerator<I>
implements ShapeDefinitionGenerator<I> {
    private static final String FILL_COLOR = ".setFillColor(\"%1s\")";
    private static final String FILL_ALPHA = ".setFillAlpha(%1s)";
    private static final String STROKE_COLOR = ".setStrokeColor(\"%1s\")";
    private static final String STROKE_ALPHA = ".setStrokeAlpha(%1s)";
    private static final String STROKE_WIDTH = ".setStrokeWidth(%1s)";

    @Override
    public StringBuffer generate(I input) throws GeneratorException {
        StringBuffer shapeRaw = super.generate(input);
        StyleDefinition styleDefinition = input.getStyleDefinition();
        if (null != styleDefinition) {
            if (null != styleDefinition.getFillColor()) {
                shapeRaw.append(AbstractShapeDefinitionGenerator.formatString(FILL_COLOR, styleDefinition.getFillColor()));
            }
            if (null != styleDefinition.getFillAlpha()) {
                shapeRaw.append(AbstractShapeDefinitionGenerator.formatDouble(FILL_ALPHA, styleDefinition.getFillAlpha()));
            }
            if (null != styleDefinition.getStrokeColor()) {
                shapeRaw.append(AbstractShapeDefinitionGenerator.formatString(STROKE_COLOR, styleDefinition.getStrokeColor()));
            }
            if (null != styleDefinition.getStrokeAlpha()) {
                shapeRaw.append(AbstractShapeDefinitionGenerator.formatDouble(STROKE_ALPHA, styleDefinition.getStrokeAlpha()));
            }
            if (null != styleDefinition.getStrokeWidth()) {
                shapeRaw.append(AbstractShapeDefinitionGenerator.formatDouble(STROKE_WIDTH, styleDefinition.getStrokeWidth()));
            }
            return shapeRaw;
        }
        return new StringBuffer();
    }
}

