/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import java.util.List;
import java.util.function.Function;
import org.kie.workbench.common.stunner.svg.client.shape.view.impl.SVGPrimitivePolicies;
import org.kie.workbench.common.stunner.svg.gen.codegen.PrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapePolicyDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.GroupDefinition;

public class SVGPrimitiveGeneratorUtils {
    public static final ShapePolicyDefinition DEFAULT_POLICY = ShapePolicyDefinition.NONE;
    public static final String NEW_SVG_CONTAINER_TEMPLATE = "SVGContainer %1s = SVGPrimitiveFactory.newSVGContainer(\"%1s\",%1s, %1s, %1s);";
    public static final String NEW_SVG_SHAPE_TEMPLATE = "SVGPrimitiveShape %1s = SVGPrimitiveFactory.newSVGPrimitiveShape(%1s, %1s, %1s, SVGPrimitivePolicies.Builder.build(%1s));";
    public static final String GROUP_ADD_CHILD_TEMPLATE = "%1s.add(%1s);";

    public static String generateSvgPrimitive(String instanceId, Function<PrimitiveDefinition, PrimitiveDefinitionGenerator<PrimitiveDefinition<?>>> generatorProvider, PrimitiveDefinition child) {
        String childRaw = null;
        try {
            StringBuffer childBuffer = generatorProvider.apply(child).generate(child);
            String scalableRaw = String.valueOf(child.isScalable());
            LayoutDefinition layoutDefinition = child.getLayoutDefinition();
            String childLayoutRaw = SVGPrimitiveGeneratorUtils.formatLayout(layoutDefinition);
            if (child instanceof ShapeDefinition) {
                String policyRaw = SVGPrimitiveGeneratorUtils.formatShapePolicy(((ShapeDefinition)child).getShapePolicyDefinition());
                childRaw = AbstractGenerator.formatString(NEW_SVG_SHAPE_TEMPLATE, instanceId, childBuffer.toString(), scalableRaw, childLayoutRaw, policyRaw);
            } else if (child instanceof GroupDefinition) {
                GroupDefinition groupDefinition = (GroupDefinition)child;
                childRaw = AbstractGenerator.formatString(NEW_SVG_CONTAINER_TEMPLATE, instanceId, groupDefinition.getId(), childBuffer.toString(), scalableRaw, childLayoutRaw);
                List<PrimitiveDefinition> children = groupDefinition.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    PrimitiveDefinition childDef = children.get(j);
                    String childDefInstanceId = instanceId + "_" + j;
                    String childDefRaw = SVGPrimitiveGeneratorUtils.generateSvgPrimitive(childDefInstanceId, generatorProvider, childDef);
                    if (null == childDefRaw) continue;
                    childRaw = childRaw + childDefRaw;
                    childRaw = childRaw + AbstractGenerator.formatString(GROUP_ADD_CHILD_TEMPLATE, instanceId, childDefInstanceId);
                }
            }
        }
        catch (GeneratorException e) {
            throw new RuntimeException(e);
        }
        return childRaw;
    }

    public static String formatShapePolicy(ShapePolicyDefinition policyDefinition) {
        if (null == policyDefinition) {
            return SVGPrimitiveGeneratorUtils.formatShapePolicy(DEFAULT_POLICY);
        }
        return SVGPrimitivePolicies.class.getName() + "." + policyDefinition.name().toUpperCase();
    }

    public static String formatLayout(LayoutDefinition layoutDefinition) {
        return null != layoutDefinition && !LayoutDefinition.NONE.equals((Object)layoutDefinition) ? LayoutContainer.class.getName() + ".Layout." + layoutDefinition.name().toUpperCase() : "null";
    }
}

