/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewShapeStateDefinition;

public class SVGShapeStateHolderCodeBuilder {
    private static final String BUILDER_START = "final SVGShapeStateHolder %1s = new SVGShapeStateHolder.Builder(ShapeState.%1s)";
    private static final String BUILDER_ALPHA = ".alpha(%1sd)";
    private static final String BUILDER_FILL_COLOR = ".fillColor(\"%1s\")";
    private static final String BUILDER_FILL_ALPHA = ".fillAlpha(%1sd)";
    private static final String BUILDER_STROKE_COLOR = ".strokeColor(\"%1s\")";
    private static final String BUILDER_STROKE_ALPHA = ".strokeAlpha(%1sd)";
    private static final String BUILDER_STROKE_WIDTH = ".strokeWidth(%1sd)";
    private static final String BUILDER_END = ".build();";
    private static final String VIEW_REGISTER = "%1s.getShapeStateHandler().registerStateHolder(%1s);";

    public static String generateStateHolders(String viewInstanceName, ViewShapeStateDefinition shapeStateDefinition) {
        String result = "";
        if (null != shapeStateDefinition) {
            for (ShapeState state : ShapeState.values()) {
                StyleDefinition styleDefinition = shapeStateDefinition.getStyleDefinition(state);
                if (null == styleDefinition) continue;
                String holdInstanceRaw = SVGShapeStateHolderCodeBuilder.generateStateHolderInstance(state, styleDefinition);
                String holdRegistrationRaw = SVGShapeStateHolderCodeBuilder.generateStateHolderViewRegistration(viewInstanceName, SVGShapeStateHolderCodeBuilder.getHolderInstanceName(state));
                result = result + holdInstanceRaw + "\n" + holdRegistrationRaw + "\n";
            }
        }
        return result;
    }

    private static String generateStateHolderViewRegistration(String viewInstanceName, String stateHolderInstanceName) {
        return AbstractGenerator.formatString(VIEW_REGISTER, viewInstanceName, stateHolderInstanceName);
    }

    private static String generateStateHolderInstance(ShapeState shapeState, StyleDefinition styleDefinition) {
        String instanceId = SVGShapeStateHolderCodeBuilder.getHolderInstanceName(shapeState);
        String result = AbstractGenerator.formatString(BUILDER_START, instanceId, shapeState.name());
        if (null != styleDefinition.getAlpha()) {
            result = result + AbstractGenerator.formatDouble(BUILDER_ALPHA, styleDefinition.getAlpha());
        }
        if (null != styleDefinition.getFillColor()) {
            result = result + AbstractGenerator.formatString(BUILDER_FILL_COLOR, styleDefinition.getFillColor());
        }
        if (null != styleDefinition.getFillAlpha()) {
            result = result + AbstractGenerator.formatDouble(BUILDER_FILL_ALPHA, styleDefinition.getFillAlpha());
        }
        if (null != styleDefinition.getStrokeColor()) {
            result = result + AbstractGenerator.formatString(BUILDER_STROKE_COLOR, styleDefinition.getStrokeColor());
        }
        if (null != styleDefinition.getStrokeAlpha()) {
            result = result + AbstractGenerator.formatDouble(BUILDER_STROKE_ALPHA, styleDefinition.getStrokeAlpha());
        }
        if (null != styleDefinition.getStrokeWidth()) {
            result = result + AbstractGenerator.formatDouble(BUILDER_STROKE_WIDTH, styleDefinition.getStrokeWidth());
        }
        result = result + BUILDER_END;
        return result;
    }

    private static String getStateName(ShapeState shapeState) {
        return shapeState.name().toLowerCase();
    }

    private static String getHolderInstanceName(ShapeState shapeState) {
        String stateName = SVGShapeStateHolderCodeBuilder.getStateName(shapeState);
        return stateName + "ShapeState";
    }
}

