/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.codegen.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;
import org.kie.workbench.common.stunner.svg.gen.codegen.PrimitiveDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.ViewDefinitionGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.AbstractGenerator;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGPrimitiveGeneratorUtils;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGShapeStateHolderCodeBuilder;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.SVGShapeTextCodeBuilder;
import org.kie.workbench.common.stunner.svg.gen.codegen.impl.ViewGenerators;
import org.kie.workbench.common.stunner.svg.gen.exception.GeneratorException;
import org.kie.workbench.common.stunner.svg.gen.model.LayoutDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.PrimitiveDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapeDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ShapePolicyDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.ViewFactory;
import org.kie.workbench.common.stunner.svg.gen.model.ViewRefDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.impl.ViewDefinitionImpl;
import org.uberfire.annotations.processors.exceptions.GenerationException;

public class SVGViewDefinitionGenerator
extends AbstractGenerator
implements ViewDefinitionGenerator<ViewDefinition<SVGShapeView>> {
    private static final String CHILD_OBJECT_ID = "child";
    public static final String PRIM_CHILD_TEMPLATE = "view.addChild(%1s);";
    private static final String SVG_CHILD_TEMPLATE = "view.addSVGChild(%1s, %1s.this.%1sBasicView());";

    @Override
    public StringBuffer generate(ViewFactory viewFactory, ViewDefinition<SVGShapeView> viewDefinition) throws GeneratorException {
        StringBuffer result = null;
        String factoryName = viewFactory.getSimpleName();
        String viewId = viewDefinition.getId();
        String methodName = viewDefinition.getFactoryMethodName();
        double x = viewDefinition.getX();
        double y = viewDefinition.getY();
        double width = viewDefinition.getWidth();
        double height = viewDefinition.getHeight();
        ShapeDefinition main = viewDefinition.getMain();
        ViewDefinition.ViewBoxDefinition viewBox = viewDefinition.getViewBox();
        if (null != main) {
            HashMap<String, Object> root = new HashMap<String, Object>();
            LinkedList<String> childrenRaw = new LinkedList<String>();
            List<PrimitiveDefinition> children = viewDefinition.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                PrimitiveDefinition child = children.get(i);
                String childId = CHILD_OBJECT_ID + i;
                String childRaw = SVGPrimitiveGeneratorUtils.generateSvgPrimitive(childId, SVGViewDefinitionGenerator::getGenerator, child);
                childRaw = null != childRaw ? childRaw + AbstractGenerator.formatString(PRIM_CHILD_TEMPLATE, childId) : "";
                childrenRaw.add(childRaw);
            }
            LinkedList svgChildrenRaw = new LinkedList();
            List<ViewRefDefinition> svgViewRefs = viewDefinition.getSVGViewRefs();
            svgViewRefs.forEach(viewRef -> {
                String parent = viewRef.getParent();
                int parentIndex = SVGViewDefinitionGenerator.getChildrenIndex(viewDefinition, parent);
                if (parentIndex < 0) {
                    throw new IllegalArgumentException("No parent found with id [" + parent + "]");
                }
                String svgName = viewRef.getFilePath();
                String viewRefId = viewRef.getViewRefId();
                boolean existReferencedView = viewFactory.getViewDefinitions().stream().anyMatch(def -> viewRefId.equals(def.getId()));
                if (!existReferencedView) {
                    throw new RuntimeException("The view [" + viewRefId + "] references another the view [" + svgName + "], but no factory method for it exists in [" + viewFactory.getImplementedType() + "]");
                }
                String childRaw = SVGViewDefinitionGenerator.formatString(SVG_CHILD_TEMPLATE, CHILD_OBJECT_ID + parentIndex, factoryName, viewRefId);
                svgChildrenRaw.add(childRaw);
            });
            PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> mainGenerator = SVGViewDefinitionGenerator.getGenerator(main);
            StringBuffer mainBuffer = mainGenerator.generate(main);
            LayoutDefinition mainLayoutDefinition = main.getLayoutDefinition();
            String mainLayoutRaw = SVGPrimitiveGeneratorUtils.formatLayout(mainLayoutDefinition);
            ShapePolicyDefinition policy = main.getShapePolicyDefinition();
            String mainPolicyRaw = SVGPrimitiveGeneratorUtils.formatShapePolicy(policy);
            String shapeStateHoldersRaw = SVGShapeStateHolderCodeBuilder.generateStateHolders("view", viewDefinition.getShapeStateDefinition());
            StyleSheetDefinition globalStyleSheetDefinition = ((ViewDefinitionImpl)viewDefinition).getGlobalStyleSheetDefinition();
            String viewTextRaw = null != globalStyleSheetDefinition ? SVGShapeTextCodeBuilder.generate("view", viewId, globalStyleSheetDefinition) : "";
            root.put("viewId", viewId);
            root.put("name", methodName);
            root.put("mainShape", mainBuffer.toString());
            root.put("layout", mainLayoutRaw);
            root.put("policy", mainPolicyRaw);
            root.put("width", SVGViewDefinitionGenerator.formatDouble(viewDefinition.getWidth()));
            root.put("height", SVGViewDefinitionGenerator.formatDouble(viewDefinition.getHeight()));
            root.put("stateHolders", shapeStateHoldersRaw);
            root.put("text", viewTextRaw);
            root.put("children", childrenRaw);
            root.put("svgChildren", svgChildrenRaw);
            try {
                result = this.writeTemplate(root);
            }
            catch (GenerationException e) {
                throw new GeneratorException(e);
            }
        }
        return result;
    }

    private static int getChildrenIndex(ViewDefinition<SVGShapeView> viewDefinition, String id) {
        List<PrimitiveDefinition> children = viewDefinition.getChildren();
        return IntStream.range(0, children.size()).filter(i -> id.equals(((PrimitiveDefinition)children.get(i)).getId())).findFirst().orElse(-1);
    }

    private static PrimitiveDefinitionGenerator<PrimitiveDefinition<?>> getGenerator(PrimitiveDefinition main) {
        PrimitiveDefinitionGenerator<?>[] array = ViewGenerators.newPrimitiveDefinitionGenerators();
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list.stream().filter(generator -> generator.getDefinitionType().equals(main.getClass())).findFirst().orElse(null);
    }

    @Override
    protected String getTemplatePath() {
        return "SVGShapeView";
    }
}

