/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.gen.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.svg.gen.model.StyleDefinition;
import org.kie.workbench.common.stunner.svg.gen.model.StyleSheetDefinition;

public final class ViewShapeStateDefinition {
    public static final String STATE_SELECTED = "shape-state-selected";
    public static final String STATE_HIGHLIGHT = "shape-state-highlight";
    public static final String STATE_INVALID = "shape-state-invalid";
    public static final Map<ShapeState, String> SHAPE_STATES_CSS_DECLARATIONS = new HashMap<ShapeState, String>(4){
        {
            this.put(ShapeState.NONE, "");
            this.put(ShapeState.SELECTED, ViewShapeStateDefinition.STATE_SELECTED);
            this.put(ShapeState.HIGHLIGHT, ViewShapeStateDefinition.STATE_HIGHLIGHT);
            this.put(ShapeState.INVALID, ViewShapeStateDefinition.STATE_INVALID);
        }
    };
    private final String selector;
    private final Map<ShapeState, StyleDefinition> stateStyleDefinitionMap;

    public ViewShapeStateDefinition(String selector) {
        this.selector = selector;
        this.stateStyleDefinitionMap = new LinkedHashMap<ShapeState, StyleDefinition>();
    }

    public String getSelector() {
        return this.selector;
    }

    public ViewShapeStateDefinition setStyleDefinition(ShapeState shapeState, StyleDefinition styleDefinition) {
        this.stateStyleDefinitionMap.put(shapeState, styleDefinition);
        return this;
    }

    public StyleDefinition getStyleDefinition(ShapeState shapeState) {
        return this.stateStyleDefinitionMap.get(shapeState);
    }

    public static ViewShapeStateDefinition build(String svgId, StyleSheetDefinition styleSheetDefinition) {
        String selector = "." + svgId;
        ViewShapeStateDefinition result = new ViewShapeStateDefinition(selector);
        SHAPE_STATES_CSS_DECLARATIONS.forEach((state, shapeStateSelector) -> ViewShapeStateDefinition.processStateClassDefinitions(state, styleSheetDefinition, selector, shapeStateSelector, result));
        return result;
    }

    private static void processStateClassDefinitions(ShapeState state, StyleSheetDefinition styleSheetDefinition, String elementSelector, String shapeStateSelector, ViewShapeStateDefinition result) {
        String cssSelector = shapeStateSelector.trim().length() > 0 ? "." + shapeStateSelector : elementSelector;
        StyleDefinition style = styleSheetDefinition.getStyle(cssSelector);
        if (null != style) {
            result.setStyleDefinition(state, style);
        }
    }
}

